/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.json;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DateMorpherExt
extends AbstractObjectMorpher {
    private Date defaultValue;
    private String[] formats;
    private boolean lenient;
    private Locale locale;

    public DateMorpherExt(String[] formats) {
        this(formats, Locale.getDefault(), false);
    }

    public DateMorpherExt(String[] formats, boolean lenient) {
        this(formats, Locale.getDefault(), lenient);
    }

    public DateMorpherExt(String[] formats, Date defaultValue) {
        this(formats, defaultValue, Locale.getDefault(), false);
    }

    public DateMorpherExt(String[] formats, Date defaultValue, Locale locale, boolean lenient) {
        super(true);
        if (formats == null || formats.length == 0) {
            throw new MorphException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
        this.setDefaultValue(defaultValue);
    }

    public DateMorpherExt(String[] formats, Locale locale) {
        this(formats, locale, false);
    }

    public DateMorpherExt(String[] formats, Locale locale, boolean lenient) {
        if (formats == null || formats.length == 0) {
            throw new MorphException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateMorpherExt)) {
            return false;
        }
        DateMorpherExt other = (DateMorpherExt)((Object)obj);
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object[])this.formats, (Object[])other.formats);
        builder.append((Object)this.locale, (Object)other.locale);
        builder.append(this.lenient, other.lenient);
        if (super.isUseDefault() && other.isUseDefault()) {
            builder.append((Object)this.getDefaultValue(), (Object)other.getDefaultValue());
            return builder.isEquals();
        }
        if (!super.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public Date getDefaultValue() {
        if (this.defaultValue != null) {
            return (Date)this.defaultValue.clone();
        }
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object[])this.formats);
        builder.append((Object)this.locale);
        builder.append(this.lenient);
        if (super.isUseDefault()) {
            builder.append((Object)this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException(value.getClass() + " is not supported");
        }
        String strValue = (String)value;
        SimpleDateFormat dateParser = null;
        for (int i = 0; i < this.formats.length; ++i) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(this.formats[i], this.locale);
            } else {
                dateParser.applyPattern(this.formats[i]);
            }
            dateParser.setLenient(this.lenient);
            try {
                return dateParser.parse(strValue.toLowerCase());
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        if (super.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Unable to parse the date " + value);
    }

    public Class<?> morphsTo() {
        return Date.class;
    }

    public void setDefaultValue(Date defaultValue) {
        this.defaultValue = defaultValue != null ? (Date)defaultValue.clone() : null;
    }

    public boolean supports(Class clazz) {
        return String.class.isAssignableFrom(clazz);
    }
}

