/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.optional;

import com.lc.ibps.base.core.util.optional.StringConsumer;
import com.lc.ibps.base.core.util.optional.StringSupplier;
import com.lc.ibps.base.core.util.string.StringUtil;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class OptionalString {
    private static final OptionalString EMPTY = new OptionalString();
    private final boolean isPresent;
    private final String value;

    private OptionalString() {
        this.isPresent = false;
        this.value = null;
    }

    public static OptionalString empty() {
        return EMPTY;
    }

    private OptionalString(String value) {
        this.isPresent = StringUtil.isNotBlank((CharSequence)value);
        this.value = value;
    }

    public static OptionalString of(String value) {
        return new OptionalString(value);
    }

    public String getAsString() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(StringConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public String orElse(String other) {
        return this.isPresent ? this.value : other;
    }

    public String orElseGet(StringSupplier other) {
        return this.isPresent ? this.value : other.getAsString();
    }

    public <X extends Throwable> String orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalString)) {
            return false;
        }
        OptionalString other = (OptionalString)obj;
        return this.isPresent && other.isPresent ? this.value.equals(other.value) : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalString[%s]", this.value) : "OptionalString.empty";
    }
}

