/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.base.core.util.string;

import com.lc.ibps.base.core.util.string.StringUtil;
import org.apache.commons.lang.StringEscapeUtils;

public class StringEscaper {
    private StringEscaper() {
    }

    public static String encodeHtml(String htmlCode) {
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(htmlCode.length() * 6);
        for (int i = 0; i < htmlCode.length(); ++i) {
            char j = htmlCode.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String decodeHtml(String src) {
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf(37, lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String escapeHtml(String html) {
        return StringEscapeUtils.escapeHtml((String)html);
    }

    public static String unescapeHtml(String content) {
        return StringEscapeUtils.unescapeHtml((String)content);
    }

    public static String escapeSql(String sql) {
        return StringEscapeUtils.escapeSql((String)sql);
    }

    public static String unescapeJson(String json) {
        return json.replace("&quot;", "\"").replace("&nuot;", "\n");
    }

    public static String changeEncode(String str, String fromEncode, String toEncode) {
        String result = str;
        try {
            result = new String(str.getBytes(fromEncode), toEncode);
        }
        catch (Exception e) {
            result = str;
        }
        return result;
    }

    public static String changeEncode(String str, String toEncode) {
        String result = str;
        try {
            result = new String(str.getBytes("GBK18030"), toEncode);
        }
        catch (Exception e) {
            try {
                result = new String(str.getBytes("GBK"), toEncode);
            }
            catch (Exception e1) {
                try {
                    result = new String(str.getBytes("GB2312"), toEncode);
                }
                catch (Exception e2) {
                    try {
                        result = new String(str.getBytes("UTF-8"), toEncode);
                    }
                    catch (Exception e3) {
                        result = str;
                    }
                }
            }
        }
        return result;
    }

    public static String toSpace(String stringWithPoint) {
        StringBuilder space = new StringBuilder();
        if (StringUtil.isEmpty((CharSequence)stringWithPoint)) {
            return space.toString();
        }
        String[] path = stringWithPoint.split("\\.");
        for (int i = 0; i < path.length - 1; ++i) {
            space.append(path[i]).append("&nbsp;&emsp;");
        }
        return space.toString();
    }

    public static String toChineseAmount(double amount) {
        char[] hunit = new char[]{'\u62fe', '\u4f70', '\u4edf'};
        char[] vunit = new char[]{'\u4e07', '\u4ebf'};
        char[] digit = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        long midVal = (long)(amount * 100.0);
        String valStr = String.valueOf(midVal);
        String head = valStr.substring(0, valStr.length() - 2);
        String rail = valStr.substring(valStr.length() - 2);
        StringBuilder prefix = new StringBuilder();
        String suffix = "";
        suffix = rail.equals("00") ? "\u6574" : StringUtil.build(Character.valueOf(digit[rail.charAt(0) - 48]), "\u89d2", Character.valueOf(digit[rail.charAt(1) - 48]), "\u5206");
        char[] chDig = head.toCharArray();
        int zero = 48;
        int zeroSerNum = 0;
        for (int i = 0; i < chDig.length; ++i) {
            int idx = (chDig.length - i - 1) % 4;
            int vidx = (chDig.length - i - 1) / 4;
            if (chDig[i] == '0') {
                zeroSerNum = (byte)(zeroSerNum + 1);
                if (zero == 48) {
                    zero = digit[0];
                    continue;
                }
                if (idx != 0 || vidx <= 0 || zeroSerNum >= 4) continue;
                prefix.append(vunit[vidx - 1]);
                zero = 48;
                continue;
            }
            zeroSerNum = 0;
            if (zero != 48) {
                prefix.append((char)zero);
                zero = 48;
            }
            prefix.append(digit[chDig[i] - 48]);
            if (idx > 0) {
                prefix.append(hunit[idx - 1]);
            }
            if (idx != 0 || vidx <= 0) continue;
            prefix.append(vunit[vidx - 1]);
        }
        if (prefix.length() > 0) {
            prefix.append('\u5706');
        }
        return StringUtil.build(prefix, suffix);
    }

    public static String toHtmlReserved(String contentWithCharEntities) {
        contentWithCharEntities = contentWithCharEntities.replace("&apos;", "'").replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        int start = 0;
        int end = 0;
        StringBuilder result = new StringBuilder();
        while (start > -1) {
            int length;
            char s;
            int system = 10;
            if (start == 0) {
                int t = contentWithCharEntities.indexOf("&#");
                if (start != t) {
                    start = t;
                }
                if (start > 0) {
                    result.append(contentWithCharEntities.substring(0, start));
                }
            }
            end = contentWithCharEntities.indexOf(59, start + 2);
            String charStr = "";
            if (end != -1 && ((s = (charStr = contentWithCharEntities.substring(start + 2, end)).charAt(0)) == 'x' || s == 'X')) {
                system = 16;
                charStr = charStr.substring(1);
            }
            try {
                char letter = (char)Integer.parseInt(charStr, system);
                result.append(Character.toString(letter));
            }
            catch (NumberFormatException letter) {
                // empty catch block
            }
            start = contentWithCharEntities.indexOf("&#", end);
            if (start - end > 1) {
                result.append(contentWithCharEntities.substring(end + 1, start));
            }
            if (start != -1 || end + 1 == (length = contentWithCharEntities.length())) continue;
            result.append(contentWithCharEntities.substring(end + 1, length));
        }
        return result.toString();
    }

    public static String toCharEntities(String contentWithHtmlReserved) {
        StringBuilder result = new StringBuilder();
        block8: for (int i = 0; i < contentWithHtmlReserved.length(); ++i) {
            char c = contentWithHtmlReserved.charAt(i);
            switch (c) {
                case '\n': {
                    result.append(c);
                    continue block8;
                }
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        result.append("&#x");
                        result.append(Integer.toString(c, 16));
                        result.append(';');
                        continue block8;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeJson(String json) {
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                case '/': {
                    result.append("\\/");
                    continue block10;
                }
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

