package com.microsoft.sqlserver.jdbc;
import java.util.*;
public final class SQLServerResource_es extends ListResourceBundle
				  {
protected Object[][]  getContents()
{
return contents;
}


static final Object[][] contents =
{
{"R_timedOutBeforeRouting","El tiempo de espera se agotó antes de conectar con el destino de enrutamiento."},
{"R_invalidRoutingInfo","Se ha recibido una información de enrutamiento inesperada. Compruebe las propiedades de su conexión y la configuración de SQL Server."},
{"R_multipleRedirections","Se han producido dos o más redireccionamientos. Solo se permite un redireccionamiento por intento de inicio de sesión."},
{"R_dbMirroringWithMultiSubnetFailover","No es compatible la conexión a una instancia de SQL Server reflejada mediante la propiedad de conexión multiSubnetFailover."},
{"R_dbMirroringWithReadOnlyIntent","No es compatible la conexión a una instancia de SQL Server reflejada mediante la propiedad de conexión ApplicationIntent ReadOnly."},
{"R_ipAddressLimitWithMultiSubnetFailover","No es compatible la conexión con una propiedad de conexión multiSubnetFailover a una instancia de SQL Server configurada con más de {0} direcciones de IP."},
{"R_connectionTimedOut","Se ha agotado el tiempo de espera de la conexión: no hay más información."},
{"R_invalidPositionIndex","El índice de posición {0} no es válido."},
{"R_invalidLength","La longitud {0} no es válida."},
{"R_unknownSSType","El tipo de datos {0} de SQL Server no es válido."},
{"R_unknownJDBCType","El tipo de datos {0} de JDBC no es válido."},
{"R_notSQLServer","El controlador ha recibido una respuesta inesperada antes del inicio de sesión. Verifique las propiedades de conexión y compruebe que hay una instancia de SQL Server ejecutándose en el host y aceptando las conexiones TCP/IP en el puerto. Este controlador solo se puede usar con SQL Server 2005 o posterior."},
{"R_tcpOpenFailed","{0}. Verifique las propiedades de conexión, compruebe que hay una instancia de SQL Server ejecutándose en el host y aceptando las conexiones TCP/IP en el puerto y compruebe que no hay ningún firewall bloqueando las conexiones TCP en el puerto."},
{"R_unsupportedServerVersion","La versión {0} de SQL Server no es compatible con este controlador."},
{"R_noServerResponse","SQL Server no devolvió una respuesta. Se ha cerrado la conexión."},
{"R_truncatedServerResponse","SQL Server devolvió una respuesta incompleta. Se cerró la conexión."},
{"R_queryTimedOut","La consulta ha superado el tiempo de espera."},
{"R_queryCancelled","La consulta se ha cancelado."},
{"R_errorReadingStream","Error al leer el valor del objeto de secuencia. Error: \"{0}\""},
{"R_streamReadReturnedInvalidValue","La operación de lectura de secuencia devolvió un valor no válido para la cantidad de datos leídos."},
{"R_mismatchedStreamLength","El valor de secuencia no presenta la longitud especificada. La longitud especificada era {0}, mientras que la longitud real es {1}."},
{"R_notSupported","Esta operación no es compatible."},
{"R_invalidOutputParameter","El índice {0} del parámetro de salida no es válido."},
{"R_outputParameterNotRegisteredForOutput","El parámetro de salida {0} no estaba registrado para salida."},
{"R_parameterNotDefinedForProcedure","El parámetro {0} no estaba definido para el procedimiento almacenado {1}."},
{"R_connectionIsClosed","La conexión está cerrada."},
{"R_invalidBooleanValue","La propiedad {0} no contiene un valor booleano válido. Sólo se pueden utilizar los valores true o false."},
{"R_propertyMaximumExceedsChars","La propiedad {0} supera el número máximo de {1} caracteres."},
{"R_invalidPortNumber","El número de puerto {0} no es válido."},
{"R_invalidTimeOut","El valor de timeout {0} no es válido."},
{"R_invalidLockTimeOut","El valor de lockTimeOut {0} no es válido."},
{"R_invalidAuthenticationScheme","El authenticationScheme {0} no es válido."},
{"R_invalidPacketSize","El packetSize {0} no es válido."},
{"R_packetSizeTooBigForSSL","No se puede utilizar el cifrado SSL con un paquete de red superior a {0} bytes.  Compruebe las propiedades de conexión y la configuración de SQL Server."},
{"R_redirectedFrom","{0} (redirigido desde {1})"},
{"R_tcpipConnectionFailed","No se pudo realizar la conexión TCP/IP al host {0}, puerto {1}. Error: \"{2}\"."},
{"R_invalidTransactionLevel","El nivel de transacción {0} no es válido."},
{"R_cantInvokeRollback","No se puede invocar a una operación de reversión cuando el modo AutoCommit está establecido en \"true\"."},
{"R_cantSetSavepoint","No se puede establecer un punto de almacenamiento si el modo AutoCommit está establecido en \"true\"."},
{"R_sqlServerHoldability","SQL Server es compatible con la capacidad de alojamiento sólo en el nivel de conexión. Utilice el método connection.setHoldability()."},
{"R_invalidHoldability","El valor de alojamiento {0} no es válido."},
{"R_invalidColumnArrayLength","La matriz de columnas no es válida. Su longitud debe ser 1."},
{"R_valueNotSetForParameter","El valor no está configurado para el número de parámetro {0}."},
{"R_sqlBrowserFailed","Error al establecer la conexión con el host {0}, instancia con nombre {1}. Error: \"{2}\". Verifique los nombres del servidor y la instancia, y compruebe que no haya ningún firewall bloqueando el tráfico UDP al puerto 1434. Para SQL Server 2005 o versiones posteriores, verifique que el servicio SQL Server Browser se esté ejecutando en el host."},
{"R_notConfiguredToListentcpip","El servidor {0} no está configurado para escuchar en TCP/IP."},
{"R_cantIdentifyTableMetadata","No se puede identificar la tabla {0} para los metadatos."},
{"R_metaDataErrorForParameter","Se ha producido un error de metadatos para el parámetro {0}."},
{"R_invalidParameterNumber","El número de parámetro {0} no es válido."},
{"R_noMetadata","No hay metadatos."},
{"R_resultsetClosed","El conjunto de resultados está cerrado."},
{"R_invalidColumnName","El nombre de columna {0} no es válido."},
{"R_resultsetNotUpdatable","El conjunto de resultados no es actualizable."},
{"R_indexOutOfRange","El índice {0} está fuera de intervalo."},
{"R_savepointNotNamed","savepoint no tiene nombre."},
{"R_savepointNamed","savepoint {0} tiene nombre."},
{"R_resultsetNoCurrentRow","El conjunto de resultados no tiene fila actual."},
{"R_mustBeOnInsertRow","El cursor no está en la fila de inserción."},
{"R_mustNotBeOnInsertRow","La operación solicitada no es válida en la fila de inserción."},
{"R_cantUpdateDeletedRow","Una fila eliminada no se puede actualizar."},
{"R_noResultset","La instrucción no devolvió un conjunto de resultados."},
{"R_resultsetGeneratedForUpdate","Se ha generado un conjunto de resultados para actualización."},
{"R_statementIsClosed","La instrucción está cerrada."},
{"R_invalidRowcount","El rowcount máximo {0} para un conjunto de resultados no debe ser negativo."},
{"R_invalidQueryTimeOutValue","El valor de tiempo de espera de consulta {0} no es válido."},
{"R_invalidFetchDirection","La dirección de recuperación {0} no es válida."},
{"R_invalidFetchSize","El tamaño de recuperación no puede ser negativo."},
{"R_noColumnParameterValue","No se han especificado valores de parámetro de columna para actualizar la fila."},
{"R_statementMustBeExecuted","La instrucción debe ejecutarse antes de obtener cualquier resultado."},
{"R_modeSuppliedNotValid","El modo proporcionado no es válido."},
{"R_errorConnectionString","La cadena de conexión contiene un nombre o valor mal formado."},
{"R_errorProcessingComplexQuery","Se ha producido un error al procesar la consulta compleja."},
{"R_invalidOffset","El desplazamiento {0} no es válido."},
{"R_nullConnection","La conexión URL es nula."},
{"R_invalidConnection","La URL de conexión no es válida."},
{"R_cannotTakeArgumentsPreparedOrCallable","El método {0} no puede tomar argumentos en PreparedStatement o CallableStatement."},
{"R_unsupportedConversionFromTo","La conversión de {0} a {1} no es compatible."},
{"R_unsupportedConversionTo","No se admite la conversión a {0}."},
{"R_errorConvertingValue","Error al convertir el valor {0} al tipo de datos JDBC {1}."},
{"R_streamIsClosed","La secuencia está cerrada."},
{"R_invalidTDS","La secuencia del protocolo TDS no es válida."},
{"R_unexpectedToken"," token inesperado {0}."},
{"R_selectNotPermittedinBatch","La instrucción SELECT no está permitida en un lote."},
{"R_failedToCreateXAConnection","Error al crear la conexión de control XA. Error: \"{0}\"."},
{"R_codePageNotSupported","La página de códigos {0} no es compatible con el entorno Java."},
{"R_unknownSortId","Este controlador no es compatible con la intercalación de SQL Server {0}."},
{"R_unknownLCID","Este controlador no es compatible con la intercalación de Windows {0}."},
{"R_encodingErrorWritingTDS","Se ha producido un error de cifrado al escribir una cadena en el búfer TDS. Error: \"{0}\"."},
{"R_processingError","Se ha producido un error de procesamiento \"{0}\"."},
{"R_requestedOpNotSupportedOnForward","La operación solicitada no es compatible en conjuntos de resultados exclusivamente de reenvío."},
{"R_unsupportedCursor","El tipo de cursor no es compatible."},
{"R_unsupportedCursorOperation","La operación solicitada no es compatible con este tipo de cursor."},
{"R_unsupportedConcurrency","La simultaneidad no es compatible."},
{"R_unsupportedCursorAndConcurrency","La combinación de tipo de cursor/simultaneidad no es compatible."},
{"R_stringReadError","Se ha producido un error de lectura de cadena en el desplazamiento:{0}."},
{"R_stringWriteError","Se ha producido un error de escritura de cadena en el desplazamiento:{0}."},
{"R_stringNotInHex","La cadena no tiene un formato hexadecimal válido."},
{"R_unknownType","El tipo Java {0} no es compatible."},
{"R_physicalConnectionIsClosed","La conexión física está cerrada para esta conexión de agrupamiento."},
{"R_invalidDataSourceReference","Referencia de DataSource no válida."},
{"R_cantGetColumnValueFromDeletedRow","No se puede obtener un valor de una fila eliminada."},
{"R_cantGetUpdatedColumnValue","No se puede acceder a las columnas actualizadas hasta que se haya llamado a updateRow() o a cancelRowUpdates()."},
{"R_cantUpdateColumn","El valor de columna no se puede actualizar."},
{"R_positionedUpdatesNotSupported","No se admiten las actualizaciones y eliminaciones posicionadas."},
{"R_invalidAutoGeneratedKeys","El valor del parámetro autoGeneratedKeys {0} no es válido. Sólo pueden utilizarse las instrucciones .RETURN_GENERATED_KEYS y .NO_GENERATED_KEYS."},
{"R_notConfiguredForIntegrated","Este controlador no está configurado para la autenticación integrada."},
{"R_failoverPartnerWithoutDB","Se requiere databaseName al utilizar la propiedad de conexión failoverPartner."},
{"R_invalidPartnerConfiguration","La base de datos {0} del servidor {1} no está configurada para realizar el reflejo de la base de datos."},
{"R_invaliddisableStatementPooling","El valor disableStatementPooling {0} no es válido."},
{"R_invalidselectMethod","El valor selectMethod {0} no es válido."},
{"R_invalidpropertyValue","El tipo data de la propiedad de conexión {0} no es válido. Todas las propiedades de esta conexión deben ser del tipo String."},
{"R_invalidArgument","El argumento {0} no es válido."},
{"R_streamWasNotMarkedBefore","La secuencia no se marcó."},
{"R_invalidresponseBuffering","La propiedad de conexión {0} de responseBuffering no es válida."},
{"R_invalidapplicationIntent","La propiedad de conexión applicationIntent {0} no es válida."},
{"R_dataAlreadyAccessed","Se obtuvo acceso a los datos y estos no están disponibles para esta columna o parámetro."},
{"R_outParamsNotPermittedinBatch","No se admiten los parámetros OUT e INOUT en este lote."},
{"R_sslRequiredNoServerSupport","El controlador no pudo establecer una conexión segura con SQL Server mediante el cifrado de Capa de sockets seguros (SSL). La aplicación solicitó un cifrado, pero el servidor no admite el cifrado SSL."},
{"R_sslRequiredByServer","El inicio de sesión de SQL Server requiere una conexión cifrada que utilice la Capa de sockets seguros (SSL)."},
{"R_sslFailed","El controlador no pudo establecer una conexión segura con SQL Server con el cifrado de Capa de sockets seguros (SSL). Error: \"{0}\"."},
{"R_certNameFailed","No se pudo validar el nombre del servidor \"{0}\" en un certificado durante la inicialización de SSL (Capa de sockets seguros). Nombre en certificado \"{1}\""},
{"R_failedToInitializeXA","No se pudo inicializar el procedimiento almacenado xp_sqljdbc_xa_init. El estado es: {0}. Error: \"{1}\""},
{"R_failedFunctionXA","Error en la función {0}. El estado es: {1}. Error: \"{2}\""},
{"R_noTransactionCookie","Error en la función {0}. No se devolvió ninguna cookie de transacción."},
{"R_failedToEnlist","Error al inscribir. Error: \"{0}\""},
{"R_failedToUnEnlist","Error al dar de baja. Error: \"{0}\""},
{"R_failedToReadRecoveryXIDs","Error al leer los ID de rama de transacción XA de recuperación (XID). Error: \"{0}\""},
{"R_userPropertyDescription","El usuario de la base de datos."},
{"R_passwordPropertyDescription","La contraseña de la base de datos."},
{"R_databaseNamePropertyDescription","El nombre de la base de datos con la que se realizará la conexión."},
{"R_domainPropertyDescription","Dominio de Windows para la autenticación mediante NTLM."},
{"R_serverNamePropertyDescription","El equipo que ejecuta SQL Server."},
{"R_portNumberPropertyDescription","El puerto TCP, donde hay una instancia de SQL Server escuchando."},
{"R_realmPropertyDescription","El dominio kerberos para la autenticación de Kerberos."},
{"R_serverSpnPropertyDescription","SPN de SQL Server."},
{"R_columnEncryptionSettingPropertyDescription","Configuración de cifrado de la columna."},
{"R_enclaveAttestationUrlPropertyDescription","Dirección URL de atestación del enclave."},
{"R_enclaveAttestationProtocolPropertyDescription","Protocolo de atestación del enclave."},
{"R_serverNameAsACEPropertyDescription","Traduce el elemento serverName de Unicode a ASCII Compatible Encoding (ACE), tal y como se define en la operación ToASCII de RFC 3490."},
{"R_sendStringParametersAsUnicodePropertyDescription","Determina si los parámetros de cadena se envían al servidor como Unicode o como juego de caracteres de la base de datos."},
{"R_multiSubnetFailoverPropertyDescription","Indica que la aplicación está conectándose al cliente de escucha de un grupo de disponibilidad o de la instancia de clúster de conmutación por error."},
{"R_applicationNamePropertyDescription","El nombre de la aplicación para las herramientas de creación de perfiles y de inicio de SQL Server."},
{"R_lastUpdateCountPropertyDescription","Asegura que únicamente se devuelve el último recuento actualizado desde una instrucción SQL enviada al servidor."},
{"R_disableStatementPoolingPropertyDescription","Deshabilita la característica de limitación de peticiones de la instrucción."},
{"R_integratedSecurityPropertyDescription","Indica si se usará la Autenticación de Windows para la conexión a SQL Server."},
{"R_authenticationSchemePropertyDescription","El esquema de autenticación utilizado para la autenticación integrada."},
{"R_lockTimeoutPropertyDescription","El número de milisegundos de espera antes de que la base de datos informe de un tiempo de espera de bloqueo."},
{"R_connectRetryCountPropertyDescription","Número de intentos de reconexión si se produce un error de conexión."},
{"R_connectRetryIntervalPropertyDescription","Número de segundos entre cada reintento de conexión."},
{"R_loginTimeoutPropertyDescription","El número de milisegundos que el controlador debería esperar antes de agotar el tiempo de espera de una conexión con errores."},
{"R_instanceNamePropertyDescription","El nombre de la instancia de SQL Server con la que se realizará la conexión."},
{"R_xopenStatesPropertyDescription","Determina si el controlador devuelve códigos de estado de SQL compatibles con XOPEN en excepciones."},
{"R_selectMethodPropertyDescription","Permite a la aplicación usar cursores de servidor para procesar conjuntos de resultados de sólo avance y de sólo lectura."},
{"R_responseBufferingPropertyDescription","Controla el comportamiento de búfer adaptable para que la aplicación pueda procesar grandes conjuntos de resultados sin requerir cursores de servidor."},
{"R_applicationIntentPropertyDescription","Declara el tipo de carga de trabajo de la aplicación al conectarse con un servidor. Los valores posibles son ReadOnly y ReadWrite."},
{"R_workstationIDPropertyDescription","El nombre de host de la estación de trabajo."},
{"R_failoverPartnerPropertyDescription","El nombre del servidor de conmutación por error usado en una configuración de creación de reflejo de la base de datos."},
{"R_packetSizePropertyDescription","El tamaño de paquete de red usado para comunicarse con SQL Server."},
{"R_encryptPropertyDescription","Determina si el cifrado de Capa de sockets seguros (SSL) se debe usar entre el cliente y el servidor."},
{"R_socketFactoryClassPropertyDescription","Clase de la que se debe crear una instancia como SocketFactory de las conexiones"},
{"R_socketFactoryConstructorArgPropertyDescription","Argumento opcional que se debe pasar al constructor especificado por socketFactoryClass"},
{"R_trustServerCertificatePropertyDescription","Determina si el controlador debe validar el certificado de Capa de sockets seguros (SSL) de SQL Server."},
{"R_trustStoreTypePropertyDescription","Tipo de KeyStore."},
{"R_trustStorePropertyDescription","La ruta de acceso al archivo de TrustStore."},
{"R_trustStorePasswordPropertyDescription","La contraseña usada para comprobar la integridad de los datos del almacén de confianza."},
{"R_trustManagerClassPropertyDescription","Clase de la que se debe crear una instancia como TrustManager de las conexiones SSL."},
{"R_trustManagerConstructorArgPropertyDescription","El argumento opcional que se debe pasar al constructor especificado por trustManagerClass."},
{"R_hostNameInCertificatePropertyDescription","El nombre del host que se usará para validar el certificado de Capa de sockets seguros (SSL) de SQL Server."},
{"R_replicationPropertyDescription","Esta configuración indica al servidor si la conexión se usa para la replicación."},
{"R_sendTimeAsDatetimePropertyDescription","Determina si usar el tipo de datos datetime de SQL Server para enviar valores java.sql.Time a la base de datos."},
{"R_TransparentNetworkIPResolutionPropertyDescription","Determina si se usa la característica de resolución de direcciones IP de red transparente."},
{"R_queryTimeoutPropertyDescription","Número de segundos de espera antes de que la base de datos informe de que se ha agotado el tiempo de espera de una consulta."},
{"R_socketTimeoutPropertyDescription","Número de milisegundos de espera antes de que se produzca una excepción java.net.SocketTimeoutException."},
{"R_serverPreparedStatementDiscardThresholdPropertyDescription","Umbral en el que se cerrarán las instrucciones de preparación descartadas en el servidor (llamando a un lote de sp_unprepares). Un valor de 1 o menor causará que se llame a sp_unprepare inmediatamente cuando se cierre PreparedStatement."},
{"R_enablePrepareOnFirstPreparedStatementCallPropertyDescription","Esta opción de configuración especifica si una instrucción preparada se prepara (sp_prepexec) la primera vez que se usa (property=true) o el segundo después de la primera llamada a sp_executesql (property=false)."},
{"R_statementPoolingCacheSizePropertyDescription","La configuración especifica el tamaño de la caché de instrucción preparada para una conexión. Si se indica un valor menor que 1, no habrá memoria caché."},
{"R_gsscredentialPropertyDescription","Credenciales de GSS suplantadas para acceder a SQL Server."},
{"R_msiClientIdPropertyDescription","Id. de cliente de la identidad administrada del usuario asignado que se usará para generar el token de acceso para la autenticación MSI de Azure AD"},
{"R_clientCertificatePropertyDescription","Ruta de certificado de cliente para la característica de autenticación de certificados de cliente."},
{"R_clientKeyPropertyDescription","Ruta de archivo de clave privada para la característica de autenticación de certificados de cliente."},
{"R_clientKeyPasswordPropertyDescription","Contraseña de la clave privada, en el caso de que esta esté protegida por contraseña."},
{"R_sendTemporalDataTypesAsStringForBulkCopyPropertyDescription","Marca que indica si el controlador enviará tipos de datos temporales como valor de cadena al servidor para la copia masiva."},
{"R_delayLoadingLobsPropertyDescription","Marca booleana que indica si el controlador cargará los tipos de datos LOB en la memoria."},
{"R_AADSecurePrincipalIdPropertyDescription","Id. de aplicación de una aplicación registrada a la que se ha concedido permiso para la base de datos conectada."},
{"R_AADSecurePrincipalSecretPropertyDescription","Secreto definido para una aplicación registrada a la que se ha concedido permiso para la base de datos conectada."},
{"R_noParserSupport","Error al crear una instancia del analizador requerido. Error: \"{0}\""},
{"R_writeOnlyXML","No se puede leer desde esta instancia de SQLXML. Únicamente se pueden escribir datos en esta instancia."},
{"R_dataHasBeenReadXML","No se puede leer desde esta instancia de SQLXML. Los datos ya se han leído."},
{"R_readOnlyXML","No se puede escribir en esta instancia SQLXML. Únicamente se pueden leer datos en esta instancia."},
{"R_dataHasBeenSetXML","No se puede escribir en esta instancia de SQLXML. Los datos ya se han establecido."},
{"R_noDataXML","No se han establecido datos en esta instancia de SQLXML."},
{"R_cantSetNull","No se puede establecer un valor NULL."},
{"R_failedToParseXML","Error al analizar XML. Error: \"{0}\""},
{"R_isFreed","Se ha liberado este objeto {0}. Ya no se puede obtener acceso al objeto."},
{"R_invalidProperty","No se admite esta propiedad: {0}."},
{"R_referencingFailedTSP","Es necesario establecer la contraseña trustStore de DataSource."},
{"R_valueOutOfRange","Uno o más valores está fuera del intervalo de valores para el tipo de datos {0} de SQL Server."},
{"R_valueOutOfRangeSQLType","Hay uno o varios valores que están fuera del intervalo de valores para el tipo SQL {0}."},
{"R_integratedAuthenticationFailed","Error en la autenticación integrada."},
{"R_permissionDenied","Infracción de seguridad. Permiso al destino \"{0}\" denegado."},
{"R_getSchemaError","Error al obtener el nombre del esquema predefinido."},
{"R_setSchemaWarning","Advertencia: setSchema es un no-op en la versión de este controlador."},
{"R_updateCountOutofRange","El valor del recuento de actualización está fuera del intervalo."},
{"R_limitOffsetNotSupported","La cláusula OFFSET de la secuencia de escape límite no se admite."},
{"R_limitEscapeSyntaxError","Error en la sintaxis de escape límite. No se pudo analizar la consulta."},
{"R_featureNotSupported","{0} no se admite."},
{"R_zoneOffsetError","Error al recuperar el desplazamiento de zona."},
{"R_invalidMaxRows","El recuento máximo de fila para un conjunto de resultados es Integer.MAX_VALUE o menor."},
{"R_schemaMismatch","Los esquemas de origen y destino no coinciden."},
{"R_invalidColumn","La columna {0} no es válida. Compruebe las asignaciones de columnas."},
{"R_invalidDestinationTable","El nombre de la tabla de destino falta o no es válido."},
{"R_unableRetrieveColMeta","No se pueden recuperar los metadatos de la columna."},
{"R_invalidDestConnection","La conexión de destino debe ser una conexión desde Microsoft JDBC Driver for SQL Server."},
{"R_unableRetrieveSourceData","No se pueden recuperar los datos del origen."},
{"R_ParsingError","No se pudieron analizar los datos del tipo {0}."},
{"R_ParsingDataError","No se pudieron analizar los datos {0} del tipo {1}."},
{"R_BulkTypeNotSupported","El tipo de datos {0} no se admite en la copia masiva."},
{"R_BulkTypeNotSupportedDW","El tipo de datos {0} no se admite en la copia masiva en Azure Data Warehouse."},
{"R_invalidTransactionOption","La opción UseInternalTransaction no se puede establecer en TRUE cuando se usa con un objeto de conexión."},
{"R_invalidNegativeArg","El argumento {0} no puede ser negativo."},
{"R_BulkColumnMappingsIsEmpty","No se puede realizar una operación de copia masiva si la única asignación es una columna de identidad y KeepIdentity está establecido en false."},
{"R_DataSchemaMismatch","Los datos de origen no coinciden con el esquema de origen."},
{"R_BulkDataDuplicateColumn","No se permiten nombres de columnas duplicados."},
{"R_invalidColumnOrdinal","La columna {0} no es válida. El número de columna debe ser mayor que cero."},
{"R_unsupportedEncoding","La codificación {0} no es compatible."},
{"R_UnexpectedDescribeParamFormat","Error interno. El formato del conjunto de resultados devuelto por sp_describe_parameter_encryption no es válido. Falta uno de los conjuntos de resultados."},
{"R_InvalidEncryptionKeyOrdinal","Error interno. Falta el ordinal de la clave de cifrado de columnas \"{0}\" a la que se hace referencia en los metadatos de cifrado devueltos por sp_describe_parameter_encryption. El ordinal máximo es \"{1}\"."},
{"R_MissingParamEncryptionMetadata","Error interno. En el conjunto de resultados devuelto por sp_describe_parameter_encryption faltan los metadatos de algunos parámetros de la instrucción o procedimiento \"{0}\"."},
{"R_UnableRetrieveParameterMetadata","No se pueden recuperar los metadatos de cifrado del parámetro."},
{"R_InvalidCipherTextSize","El texto cifrado especificado tiene un tamaño no válido de {0} bytes, que es un valor inferior a los {1} bytes mínimos requeridos para el descifrado."},
{"R_InvalidAlgorithmVersion","La versión {0} del algoritmo de cifrado del texto cifrado especificado no coincide con la versión {1} del algoritmo de cifrado esperada."},
{"R_InvalidAuthenticationTag","El texto cifrado especificado tiene una etiqueta de autenticación no válida."},
{"R_EncryptionFailed","Error interno durante el cifrado: {0} "},
{"R_DecryptionFailed","Error interno durante el descifrado: {0} "},
{"R_InvalidKeySize","La clave de cifrado de columnas se ha descifrado correctamente, pero su longitud, que es de {0}, no coincide con la longitud de {1} del algoritmo \"{2}\". Compruebe el valor cifrado de la clave de cifrado de columnas en la base de datos."},
{"R_InvalidEncryptionType","El tipo de cifrado {0} especificado para la columna en la base de datos no es válido o está dañado. Los tipos de cifrado válidos para el algoritmo {1} son: {2}."},
{"R_UnknownColumnEncryptionAlgorithm","El algoritmo {0} no existe. Los algoritmos registrados en el generador son {1}."},
{"R_KeyExtractionFailed","Error en la extracción de clave: {0}."},
{"R_UntrustedKeyPath","La ruta de la clave maestra de la columna {0} recibida del servidor {1} no es una ruta de clave de confianza. La ruta de la clave maestra de la columna puede estar dañada, o bien es necesario establecer {0} como una ruta de clave de confianza mediante SQLServerConnection.setColumnEncryptionTrustedMasterKeyPaths()."},
{"R_UnrecognizedKeyStoreProviderName","No se pudo descifrar una clave de cifrado de columnas. Nombre de proveedor de almacenamiento de claves no válido: {0}. El nombre del proveedor de almacenamiento de claves debe denotar un proveedor de almacenamiento de claves de sistema o un proveedor de almacenamiento de claves personalizadas registrado. Los nombres de proveedores de almacenamiento de claves del sistema válidos son: {1}. Los nombres de proveedores de almacenamiento de claves personalizadas válidos (registrados actualmente) son: {2}. Compruebe la información del proveedor de almacenamiento de claves en las definiciones de claves maestras de columnas de la base de datos y compruebe que todos los proveedores de almacenamiento de claves personalizadas usados en la aplicación se hayan registrado correctamente."},
{"R_UnrecognizedConnectionKeyStoreProviderName","No se pudo descifrar una clave de cifrado de columna. Nombre de proveedor de almacén de claves no válido: {0}. Un nombre de proveedor de almacén de claves debe indicar un proveedor de almacén de claves registrado. Los nombres de proveedor del almacén de claves registrados en esta conexión son: {1}. Compruebe la información del proveedor del almacén de claves en las definiciones de clave maestra de columna de la base de datos y verifique que todos los proveedores de almacén de claves usados en la aplicación estén registrados correctamente."},
{"R_UnrecognizedStatementKeyStoreProviderName","No se pudo descifrar una clave de cifrado de columna. Nombre de proveedor de almacén de claves no válido: {0}. Un nombre de proveedor de almacén de claves debe indicar un proveedor de almacén de claves registrado. Los nombres de proveedor del almacén de claves registrados en esta instrucción son: {1}. Compruebe la información del proveedor del almacén de claves en las definiciones de clave maestra de columna de la base de datos y verifique que todos los proveedores de almacén de claves usados en la aplicación estén registrados correctamente."},
{"R_UnsupportedDataTypeAE","El cifrado y descifrado del tipo de datos {0} no son compatibles."},
{"R_NormalizationErrorAE","Error en el descifrado del tipo de datos {0}. Error de normalización."},
{"R_UnsupportedNormalizationVersionAE","La versión de normalización \"{0}\" recibida de SQL Server no es válida o está dañada. Las versiones de normalización válidas son: {1}."},
{"R_NullCipherTextAE","Error interno. El valor de Ciphertext no puede ser nulo."},
{"R_NullColumnEncryptionAlgorithmAE","Error interno. El algoritmo de cifrado no puede ser nulo. Los algoritmos válidos son: {1}."},
{"R_CustomCipherAlgorithmNotSupportedAE","El algoritmo de cifrado personalizado no es compatible."},
{"R_PlainTextNullAE","Error interno. El valor de Plaintext no puede ser nulo."},
{"R_StreamingDataTypeAE","Los datos con una longitud superior a {0} no son compatibles con la columna cifrada {1}."},
{"R_AE_NotSupportedByServer","El SQL Server en uso no admite el cifrado de columnas."},
{"R_InvalidAEVersionNumber","Número de versión no válido \"{0}\" recibido para Always Encrypted."},
{"R_NullEncryptedColumnEncryptionKey","Error interno. La clave de cifrado de columnas cifradas no puede ser nula."},
{"R_EmptyEncryptedColumnEncryptionKey","Error interno. Se ha especificado una clave de cifrado de columnas cifradas vacía."},
{"R_InvalidMasterKeyDetails","Se han especificado detalles de la clave maestra que no son válidos."},
{"R_CertificateError","Se ha producido un error al recuperar el certificado \"{0}\" del almacén de claves \"{1}\"."},
{"R_ByteToShortConversion","Se ha producido un error al descifrar la clave de cifrado de columna."},
{"R_InvalidCertificateSignature","La firma de la clave de cifrado de columnas cifradas especificada no coincide con la firma calculada con la clave maestra de columnas (certificado) en \"{0}\". Puede que la clave de cifrado de columnas cifradas esté dañada o que la ruta especificada no sea correcta."},
{"R_CEKDecryptionFailed","Excepción al descifrar la clave de cifrado de columnas cifradas: {0} "},
{"R_NullKeyEncryptionAlgorithm","El algoritmo de cifrado de claves no puede ser nulo."},
{"R_NullKeyEncryptionAlgorithmInternal","Error interno. El algoritmo de cifrado de claves no puede ser nulo."},
{"R_InvalidKeyEncryptionAlgorithm","Se ha especificado un algoritmo de cifrado de claves no válido: {0}. Valor esperado: {1}."},
{"R_InvalidKeyEncryptionAlgorithmInternal","Error interno. Se ha especificado un algoritmo de cifrado de claves no válido: {0}. Valor esperado: {1}."},
{"R_NullColumnEncryptionKey","La clave de cifrado de columnas no puede ser nula."},
{"R_EmptyColumnEncryptionKey","La clave de cifrado de columnas especificada está vacía."},
{"R_CertificateNotFoundForAlias","El certificado con alias {0} no se encuentra en el almacén proporcionado por {1}. Compruebe que el certificado se haya importado correctamente en el almacén o en la ubicación del certificado."},
{"R_UnrecoverableKeyAE","No se puede recuperar la clave privada del almacén de claves con los detalles del certificado {0}. Compruebe que el certificado importado de Always Encrypted sea correcto, ya que este contiene la clave privada y la contraseña proporcionada para el certificado."},
{"R_KeyStoreNotFound","El sistema no puede encontrar el archivo de almacenamiento de claves en la ruta especificada. Compruebe que la ruta sea correcta y que tenga los permisos adecuados para acceder a ella."},
{"R_CustomKeyStoreProviderMapNull","El mapa del proveedor de almacenamiento de claves de cifrado de columnas no puede ser nulo. Se espera un valor no nulo."},
{"R_EmptyCustomKeyStoreProviderName","El nombre de proveedor de almacenamiento de claves especificado no es válido. Los nombres de los proveedores de almacenamiento de claves no pueden ser nulos ni estar vacíos."},
{"R_InvalidCustomKeyStoreProviderName","El nombre del proveedor de almacenamiento de claves {0} no es válido. El prefijo {1} está reservado para los proveedores de almacenamiento de claves del sistema."},
{"R_CustomKeyStoreProviderValueNull","Se ha especificado una referencia nula para el proveedor de almacenamiento de claves {0}. Se espera un valor no nulo."},
{"R_CustomKeyStoreProviderSetOnce","Los proveedores de almacenamiento de claves no se pueden establecer más de una vez."},
{"R_unknownColumnEncryptionType","El tipo de cifrado de columnas {0} no es válido."},
{"R_unsupportedStmtColEncSetting","SQLServerStatementColumnEncryptionSetting no puede ser nulo."},
{"R_unsupportedConversionAE","La conversión de {0} a {1} no es compatible con la columna cifrada."},
{"R_InvalidDataForAE","El valor del tipo especificado {0} del origen de datos no se puede convertir al tipo {1} de la columna {2} de destino especificada."},
{"R_authenticationPropertyDescription","Autenticación que se debe usar."},
{"R_accessTokenPropertyDescription","Token de acceso que se debe usar para Azure Active Directory."},
{"R_FedAuthRequiredPreLoginResponseInvalidValue","El servidor ha enviado un valor inesperado para la opción FedAuthRequired PreLogin. El valor era {0}."},
{"R_FedAuthInfoLengthTooShortForCountOfInfoIds","El token FedAuthInfo debe contener como mínimo 4 bytes que indiquen el número de identificadores de información."},
{"R_FedAuthInfoInvalidOffset","FedAuthInfoDataOffset indica una ubicación no válida. El valor dataOffset actual es {0}."},
{"R_FedAuthInfoFailedToReadData","No se pudo leer FedAuthInfoData."},
{"R_FedAuthInfoLengthTooShortForData","La secuencia de token FEDAUTHINFO no es lo suficientemente larga ({0}) para contener los datos que reclama."},
{"R_FedAuthInfoDoesNotContainStsurlAndSpn","La secuencia de token FEDAUTHINFO no contiene STSURL ni SPN."},
{"R_MSALExecution","No se pudo autenticar el usuario {0} en Active Directory (Authentication={1})."},
{"R_MSALAuthComplete","Autenticación completada. Puede cerrar el explorador y volver a la aplicación."},
{"R_UnrequestedFeatureAckReceived","Se ha recibido una confirmación de característica no solicitada. Id. de la característica: {0}."},
{"R_FedAuthFeatureAckContainsExtraData","La confirmación de la extensión de características de autenticación federada ADAL y Security Token incluye datos adicionales."},
{"R_FedAuthFeatureAckUnknownLibraryType","Se está intentando usar una biblioteca de autenticación federada desconocida. Id. de la biblioteca: {0}."},
{"R_UnknownFeatureAck","Se ha recibido una confirmación de características desconocidas."},
{"R_SetAuthenticationWhenIntegratedSecurityTrue","No se puede establecer \"Authentication\" con \"IntegratedSecurity\" establecido en \"True\"."},
{"R_NtlmNoUserPasswordDomain","Deben especificarse las propiedades de conexión \"User\" (o \"UserName\") y \"Password\" para la autenticación NTLM."},
{"R_SetAccesstokenWhenIntegratedSecurityTrue","No se puede establecer la propiedad AccessToken si la palabra clave de cadena de conexión \"IntegratedSecurity\" se ha establecido en \"True\"."},
{"R_IntegratedAuthenticationWithUserPassword","No se puede usar \"Authentication=ActiveDirectoryIntegrated\" con las palabras clave de cadena de conexión \"User\", \"UserName\" o \"Password\"."},
{"R_MSIAuthenticationWithUserPassword","No se puede usar \"Authentication=ActiveDirectoryMSI\" con las palabras clave de cadena de conexión \"User\", \"UserName\" o \"Password\"."},
{"R_AccessTokenWithUserPassword","No se puede establecer la propiedad AccessToken si se ha especificado \"User\", \"UserName\" o \"Password\" en la cadena de conexión."},
{"R_AccessTokenCannotBeEmpty","AccesToken no puede estar vacío."},
{"R_SetBothAuthenticationAndAccessToken","No se puede establecer la propiedad AccessToken si se ha especificado \"Authentication\" en la cadena de conexión."},
{"R_NoUserPasswordForActivePassword","Si \"Authentication=ActiveDirectoryPassword\", las palabras clave de cadena de conexión \"User\" (o \"UserName\") y \"Password\" deben especificarse."},
{"R_NoUserPasswordForActiveServicePrincipal","Si \"Authentication=ActiveDirectoryServicePrincipal\", las palabras clave de cadena de conexión \"UserName\" y \"Password\" deberán especificarse."},
{"R_NoUserPasswordForSqlPassword","Si \"Authentication=SqlPassword\", las palabras clave de cadena de conexión \"User\" (o \"UserName\") y \"Password\" deben especificarse."},
{"R_BothUserPasswordandDeprecated","Se especificaron las palabras clave de cadena de conexión \"User\" (o \"UserName\"), \"Password\", \"AADSecurePrincipalId\" y \"AADSecurePrincipalSecret\". Use solo \"User\" (o \"UserName\"), \"Password\"."},
{"R_ForceEncryptionTrue_HonorAEFalse","No se puede establecer el valor de Forzar cifrado en \"true\" para el parámetro {0} porque el cifrado no está habilitado para la instrucción o el procedimiento {1}."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn","No se puede ejecutar la instrucción o el procedimiento {0} porque el valor de Force Encryption se ha establecido como \"True\" para el parámetro {1} y la base de datos espera que este parámetro se envíe como texto sin formato. Esto puede deberse a un error de configuración."},
{"R_ForceEncryptionTrue_HonorAEFalseRS","No se puede establecer el valor de Forzar cifrado en \"true\" para el parámetro {0} porque el cifrado no está habilitado para la instrucción o el procedimiento."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumnRS","No se puede ejecutar la actualización porque el valor de Force Encryption se ha establecido como \"True\" para el parámetro {0} y la base de datos espera que este parámetro se envíe como texto sin formato. Esto puede deberse a un error de configuración."},
{"R_NullValue","{0} no puede ser nulo."},
{"R_AKVPathNull","La ruta de las claves de Azure Key Vault no puede ser nula."},
{"R_AKVURLInvalid","La dirección URL especificada no es válida: {0}."},
{"R_AKVMasterKeyPathInvalid","La ruta de las claves de Azure Key Vault especificada no es válida: {0}."},
{"R_ManagedIdentityInitFail","No se pudo inicializar el paquete para obtener el token de identidad administrada para Azure Key Vault."},
{"R_EmptyCEK","La clave de cifrado de columnas especificada está vacía."},
{"R_EncryptedCEKNull","La clave de cifrado de columnas cifradas no puede ser nula."},
{"R_EmptyEncryptedCEK","La longitud de la clave de cifrado de columnas cifradas no debe ser cero."},
{"R_NonRSAKey","No se puede usar una clave que no sea RSA: {0}."},
{"R_GetAKVKeySize","No se puede obtener el tamaño de la clave pública de Azure Key Vault en bytes."},
{"R_InvalidEcryptionAlgorithmVersion","La clave de cifrado de columnas cifradas especificada contiene una versión {0} de algoritmo de cifrado no válida. La versión esperada es {1}."},
{"R_AKVKeyLengthError","La longitud del elemento ciphertext de la clave de cifrado de columnas cifradas especificada, que es de {0}, no coincide con la longitud del texto cifrado, de {1}, al usar una clave maestra de columnas (clave de Azure Key Vault) en {2}. Puede que la clave de cifrado de columnas cifradas esté dañada o que la ruta especificada de la clave de Azure Key Vault no sea correcta."},
{"R_AKVSignatureLengthError","La longitud de la firma de la clave de cifrado de columnas cifradas especificada, que es de {0}, no coincide con la longitud de la firma, de {1}, al usar una clave maestra de columnas (clave de Azure Key Vault) en {2}. Puede que la clave de cifrado de columnas cifradas esté dañada o que la ruta especificada de la clave de Azure Key Vault no sea correcta."},
{"R_HashNull","El hash no debe ser nulo al descifrar la clave de cifrado de columnas cifradas."},
{"R_NoSHA256Algorithm","El algoritmo SHA-256 no es compatible."},
{"R_VerifySignature","No se puede comprobar la firma de la clave de cifrado de columnas."},
{"R_CEKSignatureNotMatchCMK","La firma de la clave de cifrado de columnas cifradas especificada no coincide con la firma calculada mediante la clave maestra de columnas (clave asimétrica de Azure Key Vault ) en {0}. Puede que la clave de cifrado de columnas cifradas esté dañada o que la ruta especificada no sea correcta."},
{"R_DecryptCEKError","No se puede descifrar la clave de cifrado de columna mediante la clave especificada de Azure Key Vault."},
{"R_EncryptCEKError","No se puede cifrar la clave de cifrado de columna mediante la clave especificada de Azure Key Vault."},
{"R_CipherTextLengthNotMatchRSASize","La longitud de CipherText no coincide con el tamaño de la clave RSA."},
{"R_GenerateSignature","No se puede generar la firma con la dirección URL de clave especificada de Azure Key Vault."},
{"R_SignedHashLengthError","La longitud del hash firmado no coincide con el tamaño de la clave RSA."},
{"R_InvalidSignatureComputed","La firma de la clave de cifrado de columnas cifradas calculada no es válida."},
{"R_UnableLoadADALSqlDll","No se puede cargar adalsql.dll. Código de error: 0x{0}. Para obtener más información, consulte: http://go.microsoft.com/fwlink/?LinkID=513072."},
{"R_ADALAuthenticationMiddleErrorMessage","Código de error 0x{0}; estado {1}."},
{"R_unsupportedDataTypeTVP","El tipo de datos {0} no es compatible con Table-Valued Parameter."},
{"R_moreDataInRowThanColumnInTVP","La matriz de entrada es más larga que el número de columnas incluidas en esta tabla."},
{"R_invalidTVPName","El elemento Table-Valued Parameter debe tener un nombre de tipo válido."},
{"R_invalidThreePartName","El formato de nombre con 3 elementos no es válido para TypeName."},
{"R_unsupportedConversionTVP","La conversión de {0} a {1} no es compatible con Table-Valued Parameter."},
{"R_TVPMixedSource","No se pueden agregar metadatos de columna. Este elemento Table-Valued Parameter tiene un ResultSet del que se derivarán los metadatos."},
{"R_TVPEmptyMetadata","No hay suficientes campos en el tipo Structured. Los tipos Structured deben tener al menos un campo."},
{"R_TVPInvalidValue","El valor proporcionado para Table-Valued Parameter {0} no es válido. Solo se admiten los objetos SQLServerDataTable, ResultSet y ISQLServerDataRecord."},
{"R_TVPInvalidColumnValue","El formato de los datos de entrada no es correcto."},
{"R_TVPSortOrdinalGreaterThanFieldCount","El ordinal de ordenación {0} en el campo {1} supera el número total de campos."},
{"R_TVPMissingSortOrderOrOrdinal","Es necesario especificar tanto el criterio como el ordinal de ordenación, o bien ninguno de ellos (SortOrder.Unspecified y -1). Valores proporcionados: criterio = {0}, ordinal = {1}."},
{"R_TVPDuplicateSortOrdinal","El ordinal de ordenación {0} se ha especificado dos veces."},
{"R_TVPMissingSortOrdinal","El ordinal de ordenación {0} no se ha especificado."},
{"R_TVPDuplicateColumnName","El nombre de columna {0} ya pertenece a este elemento SQLServerDataTable."},
{"R_InvalidConnectionSetting","El valor {0} \"{1}\" no es válido."},
{"R_InvalidWindowsCertificateStoreEncryption","No se puede cifrar una clave de cifrado de columnas con Windows Certificate Store."},
{"R_AEKeypathEmpty","Error interno. La ruta de certificado no puede ser nula. Use el siguiente formato: \"ubicación del certificado/almacén del certificado/huella digital del certificado\", donde \"ubicación del certificado\" es LocalMachine o CurrentUser."},
{"R_AEWinApiErr","Error nativo de la API de Windows."},
{"R_AECertpathBad","Error interno. Error interno. La ruta de certificado no es válida: {0}. Use el siguiente formato: \"ubicación del certificado/almacén del certificado/huella digital del certificado\", donde \"ubicación del certificado\" es LocalMachine o CurrentUser."},
{"R_AECertLocBad","Error interno. La ubicación de certificado {0} en la ruta de certificado {1} no es válida. Use el siguiente formato: \"ubicación del certificado/almacén del certificado/huella digital del certificado\", donde \"ubicación del certificado\" es LocalMachine o CurrentUser."},
{"R_AECertStoreBad","Error interno. Se ha especificado un almacén de certificados {0} no válido en la ruta de certificado {1}. Valor esperado: My."},
{"R_AECertHashEmpty","Error interno. Se ha especificado una huella digital de certificado vacía en la ruta de certificado {0}."},
{"R_AECertNotFound","El certificado con huella digital {2} no se ha encontrado en el almacén de certificados {1} de la ubicación de certificado {0}. Compruebe que la ruta del certificado en la definición de clave maestra de columnas de la base de datos sea correcta y que el certificado se haya importado correctamente en el almacén o en la ubicación de certificados."},
{"R_AEMaloc","Error de asignación de memoria."},
{"R_AEKeypathLong","Error interno. La ruta de certificado especificada tiene {0} bytes, lo que supera la longitud máxima de {1} bytes."},
{"R_AEECEKLenBad","La longitud del elemento ciphertext de la clave de cifrado de columnas cifradas especificada, que es de {0}, no coincide con la longitud del texto cifrado, de {1}, al usar una clave maestra de columnas (certificado) en \"{2}\". Puede que la clave de cifrado de columnas cifradas esté dañada o que la ruta especificada del certificado no sea correcta."},
{"R_AEECEKSigLenBad","La longitud de la firma de la clave de cifrado de columnas cifradas especificada, que es de {0}, no coincide con la longitud de {1} al usar la clave maestra de columnas (certificado) en \"{2}\". Puede que la clave de cifrado de columnas cifradas esté dañada o que la ruta especificada del certificado no sea correcta."},
{"R_AEKeyPathEmptyOrReserved","La ruta de certificado \"{0}\" no es válida, ya que está vacía o contiene nombres de directorio reservados."},
{"R_AEKeyPathCurUser","El elemento CurrentUser se ha especificado en la ruta de claves, pero se ha producido un error al obtener el directorio de trabajo inicial del usuario actual."},
{"R_AEKeyFileOpenError","Error al abrir el archivo de certificado {0}."},
{"R_AEKeyFileReadError","Error al leer el archivo de certificado {0}."},
{"R_keyStoreAuthenticationPropertyDescription","Nombre que identifica un almacén de claves."},
{"R_keyStoreSecretPropertyDescription","Secreto de autenticación o información necesaria para encontrar el secreto."},
{"R_keyStoreLocationPropertyDescription","Ubicación del almacén de claves."},
{"R_keyStoreAuthenticationNotSet","Si se especifica \"{0}\", es necesario especificar la palabra clave de cadena de conexión \"keyStoreAuthentication\"."},
{"R_keyStoreSecretOrLocationNotSet","Si \"keyStoreAuthentication=JavaKeyStorePassword\" se ha especificado en la cadena de conexión, es necesario establecer tanto \"keyStoreSecret\" como \"keyStoreLocation\"."},
{"R_keyStoreSecretNotSet","Debe establecerse \"keyStoreSecret\" si \"keyStoreAuthentication=KeyVaultClientSecret\" se ha especificado en la cadena de conexión."},
{"R_keyVaultProviderClientKeyNotSet","Se debe establecer \"keyVaultProviderClientKey\" si se ha especificado \"keyVaultProviderClientId\" en la cadena de conexión."},
{"R_keyVaultProviderNotSupportedWithKeyStoreAuthentication","\"keyStoreAuthentication\" no se puede usar con \"keyVaultProviderClientId\" o \"keyVaultProviderClientKey\" en la cadena de conexión."},
{"R_certificateStoreInvalidKeyword","Si \"keyStoreAuthentication=CertificateStore\" se ha especificado en la cadena de conexión, no se puede establecer \"keyStoreSecret\"."},
{"R_certificateStoreLocationNotSet","Si \"keyStoreAuthentication=CertificateStore\" se ha especificado en la cadena de conexión, es necesario establecer \"keyStoreLocation\"."},
{"R_certificateStorePlatformInvalid","\"keyStoreAuthentication=CertificateStore\" no se puede establecer en un sistema operativo Windows."},
{"R_invalidKeyStoreFile","No se puede analizar \"{0}\". El formato de archivo no es válido o bien la contraseña no es correcta."},
{"R_invalidCEKCacheTtl","Se ha especificado un período de vida de la caché para la clave de cifrado de columnas que no es válido. El valor columnEncryptionKeyCacheTtl no puede ser negativo, y timeUnit solo puede contener DAYS, HOURS, MINUTES o SECONDS."},
{"R_sendTimeAsDateTimeForAE","Use sendTimeAsDateTime=false con Always Encrypted."},
{"R_TVPnotWorkWithSetObjectResultSet","setObject() con ResultSet no es compatible con el parámetro con valores de tabla. Utilice setStructured()."},
{"R_invalidQueryTimeout","El valor de queryTimeout {0} no es válido."},
{"R_invalidSocketTimeout","El valor de socketTimeout {0} no es válido."},
{"R_fipsPropertyDescription","Determina si el modo FIPS está habilitado."},
{"R_invalidFipsConfig","No se puede comprobar la configuración del modo FIPS."},
{"R_serverPreparedStatementDiscardThreshold","El valor de serverPreparedStatementDiscardThreshold {0} no es válido."},
{"R_statementPoolingCacheSize","El valor de statementPoolingCacheSize {0} no es válido."},
{"R_kerberosLoginFailedForUsername","No se puede iniciar sesión con la entidad de seguridad de Kerberos {0}. Compruebe sus credenciales. {1}"},
{"R_kerberosLoginFailed","Error en el inicio de sesión de Kerberos: {0} debido a {1} ({2})"},
{"R_StoredProcedureNotFound","No se ha podido encontrar el procedimiento almacenado \"{0}\"."},
{"R_jaasConfigurationNamePropertyDescription","Archivo de configuración de inicio de sesión para la autenticación Kerberos."},
{"R_AKVKeyNotFound","No se encuentra la clave: {0}."},
{"R_SQLVariantSupport","SQL_VARIANT no es compatible con las versiones de SQL Server anteriores a la 2008."},
{"R_invalidProbbytes","SQL_VARIANT: valor probBytes no válido para el tipo {0}."},
{"R_invalidStringValue","SQL_VARIANT no es compatible con los valores de cadena que tengan una longitud superior a 8000."},
{"R_invalidValueForTVPWithSQLVariant","No se admite el uso de TVP que contengan columnas de sql_variant nulas."},
{"R_invalidDataTypeSupportForSQLVariant","Tipo de TDS \"{0}\" inesperado en SQL_VARIANT."},
{"R_sslProtocolPropertyDescription","Etiqueta de protocolo SSL de TLS, TLSv1, TLSv1.1 y TLSv1.2. La predeterminada es TLS."},
{"R_invalidSSLProtocol","La etiqueta de protocolo SSL {0} no es válida. Solo se admiten TLS, TLSv1, TLSv1.1 y TLSv1.2."},
{"R_cancelQueryTimeoutPropertyDescription","Número de segundos de espera para cancelar el envío de un tiempo de expiración de una consulta."},
{"R_invalidCancelQueryTimeout","El valor del tiempo de expiración para la cancelación {0} no es válido."},
{"R_useBulkCopyForBatchInsertPropertyDescription","Indica si el controlador usará la API de copia masiva para las operaciones de inserción por lotes."},
{"R_UnknownDataClsTokenNumber","El token para la clasificación de datos es desconocido."},
{"R_InvalidDataClsVersionNumber","El número de versión {0} no es válido para la clasificación de datos."},
{"R_unknownUTF8SupportValue","El valor para la compatibilidad de UTF8 es desconocido."},
{"R_unknownAzureSQLDNSCachingValue","Valor desconocido para el almacenamiento en caché de DNS de Azure SQL."},
{"R_illegalWKT","El texto conocido no es válido. Asegúrese de que lo sea."},
{"R_illegalTypeForGeometry","{0} no se admite para Geometry."},
{"R_illegalWKTposition","Se ha detectado un carácter no válido en la posición {0} del texto conocido."},
{"R_keyVaultProviderClientIdPropertyDescription","Id. de cliente que se usa para obtener acceso a Key Vault, donde se almacena la clave maestra del cifrado de columnas."},
{"R_keyVaultProviderClientKeyPropertyDescription","Clave de cliente que se usa para obtener acceso a Key Vault, donde se almacena la clave maestra del cifrado de columnas."},
{"R_keyStorePrincipalIdPropertyDescription","Id. de entidad de seguridad de Azure Active Directory."},
{"R_MSALMissing","No se pudo cargar la biblioteca de Java MSAL4J para llevar a cabo la autenticación de {0}."},
{"R_DLLandMSALMissing","No se pudieron cargar {0} ni la biblioteca de Java MSAL4J para llevar a cabo la autenticación de {1}. Instale uno de ellos para continuar."},
{"R_MSITokenFailureImds","Error de token MSI: no se pudo adquirir el token de acceso de IMDS."},
{"R_MSITokenFailureImdsClientId","Error de token MSI: no se pudo adquirir el token de acceso de IMDS; verifique el elemento clientId."},
{"R_MSITokenFailureUnexpected","Error de token MSI: no se pudo adquirir el token de acceso de IMDS; error inesperado."},
{"R_MSITokenFailureEndpoint","Error de token MSI: no se pudo adquirir el token del punto de conexión MSI."},
{"R_propertyNotSupported","En estos momentos, Microsoft JDBC Driver para SQL Server no admite la propiedad {0}."},
{"R_ntlmHmacMD5Error","No se puede inicializar la autenticación NTLM: error de inicialización HMAC-MD5."},
{"R_ntlmSignatureError","Error de firma del mensaje de desafío NTLM: {0}"},
{"R_ntlmMessageTypeError","Error de tipo de mensaje de desafío de NTLM: {0}"},
{"R_ntlmAuthenticateError","Error de NTLM al construir el mensaje de autenticación: {0}"},
{"R_ntlmNoTargetInfo","Falta TargetInfo en el mensaje de desafío NTLM."},
{"R_ntlmUnknownValue","Error de TargetInfo del mensaje de desafío NTLM: valor desconocido \"{0}\""},
{"R_useFmtOnlyPropertyDescription","Determina si se debe habilitar o deshabilitar el uso de SET FMTONLY para recuperar los metadatos del parámetro."},
{"R_invalidOpenqueryCall","Sintaxis no válida: OPENQUERY/OPENJSON/OPENDATASOURCE/OPENROWSET/OPENXML deben ir precedidos por corchetes redondos."},
{"R_invalidCTEFormat","Sintaxis no válida: AS debe ir seguido de corchetes redondos en las expresiones de tablas comunes."},
{"R_noTokensFoundInUserQuery","Consulta no válida: no se ha analizado ningún token desde la sintaxis SQL proporcionada."},
{"R_invalidUserSQL","Se ha producido un error al intentar analizar la sintaxis SQL del usuario. Compruebe la sintaxis SQL."},
{"R_invalidInsertValuesQuery","Se ha producido un error al asociar la lista VALUES a las columnas de la tabla. Compruebe la sintaxis SQL."},
{"R_invalidValuesList","Se ha producido un error al leer la lista VALUES. Compruebe la sintaxis SQL."},
{"R_enclaveNotSupported","El SQL Server no admite cálculos basados en enclave; consulte https://go.microsoft.com/fwlink/?linkid=2157649 obtener más detalles."},
{"R_enclavePropertiesError","La propiedad de conexión \"columnEncryptionSetting\" debe estar habilitada junto con las propiedades de conexión válidas \"enclaveAttestationUrl\" y \"enclaveAttestationProtocol\" al habilitar Always Encrypted con enclaves seguros; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para obtener más detalles."},
{"R_enclaveInvalidAttestationProtocol","\"EnclaveAttestationProtocol\" no es válido; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para obtener más detalles."},
{"R_enclaveTypeInvalid","El tipo de enclave {0} no es válido o no es compatible con el controlador; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para más detalles."},
{"R_attestationUrlInvalid","No se puede atestiguar el enclave especificado por {0}; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para obtener más detalles ."},
{"R_EnclaveResponseLengthError","Se recibieron más bytes del servidor de los esperados al analizar la contestación de atestación del enclave; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para obtener más detalles ."},
{"R_EnclavePackageLengthError","Se recibieron más bytes del servidor de los esperados al analizar el paquete del enclave; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para obtener más detalles ."},
{"R_EnclavePKLengthError","Se recibieron más bytes del servidor de los esperados al analizar la clave pública del enclave; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para obtener más detalles ."},
{"R_MalformedECDHPublicKey","La clave pública ECDH del servidor debe tener una longitud de 104 bits."},
{"R_MalformedECDHHeader","El servidor ha proporcionado valores inesperados para el encabezado de clave pública ECDH."},
{"R_HealthCertError","Error de atestación del enclave. No se pudieron recuperar los certificados del informe de estado proporcionados en el enclave;{0} consulte https://go.microsoft.com/fwlink/?linkid=2160553 para obtener más detalles ."},
{"R_InvalidHealthCert","Error de atestación del enclave. El certificado del informe de estado proporcionado en el enclave no fue firmado por HGS; consulte https://go.microsoft.com/fwlink/?linkid=2160553 para obtener más detalles."},
{"R_InvalidSignedStatement","Error de atestación de enclave. El certificado de mantenimiento no firmó los bytes de instrucción de acción; consulte https://go.microsoft.com/fwlink/?linkid=2160553 para obtener más detalles ."},
{"R_InvalidDHKeySignature","Error en la atestación del enclave. No se puede comprobar la firma de clave pública DH con la clave pública del enclave; consulte https://go.microsoft.com/fwlink/?linkid=2157649 para obtener más detalles ."},
{"R_AasJWTError","Ha habido un error al recuperar y validar el token web JSON."},
{"R_AasEhdError","La solicitud aas-ehd de JWT no coincide con la clave pública del enclave."},
{"R_VbsRpDataError","La solicitud rp_data de JWT no coincide con el valor nonce del cliente."},
{"R_pvkParseError","No se ha podido leer la clave privada de PVK. Compruebe la contraseña proporcionada."},
{"R_pvkHeaderError","No se puede analizar el archivo PVK, ya que no contiene el encabezado correcto."},
{"R_clientCertError","Error al leer el certificado de cliente. Compruebe la ubicación del certificado."},
{"R_unassignableError","La clase especificada por la propiedad {0} debe poder asignarse a {1}."},
{"R_InvalidCSVQuotes","No se pudo analizar el archivo CSV. Compruebe que los campos estén indicados correctamente entre comillas dobles."},
{"R_TokenRequireUrl","Las credenciales de token requieren una dirección URL que use el esquema de protocolo HTTPS."},
{"R_maxResultBufferPropertyDescription","Determina la cantidad máxima de bytes que se puede leer durante la recuperación del conjunto de resultados."},
{"R_maxResultBufferInvalidSyntax","Sintaxis no válida: {0} en el parámetro maxResultBuffer."},
{"R_maxResultBufferNegativeParameterValue","El valor de MaxResultBuffer debe ser positivo: {0}."},
{"R_maxResultBufferPropertyExceeded","Se ha superado la propiedad MaxResultBuffer: {0}. La propiedad MaxResultBuffer está establecida en {1}."},
{"R_invalidConnectRetryCount","El número de reintentos de conexión {0} no es válido."},
{"R_connectRetryCountPropertyDescription","Número máximo de intentos para restablecer una conexión interrumpida."},
{"R_invalidConnectRetryInterval","El intervalo de reintento de conexión {0} no es válido."},
{"R_connectRetryIntervalPropertyDescription","Intervalo, en segundos, entre intentos de restablecer una conexión."},
{"R_crClientAllRecoveryAttemptsFailed","La conexión se ha perdido y no es posible recuperarla. El controlador cliente intentó recuperar la conexión una o más veces sin conseguirlo. Aumente el valor de ConnectRetryCount para aumentar el número de intentos de recuperación."},
{"R_crClientNoRecoveryAckFromLogin","El servidor no reconoció un intento de recuperación; no es posible recuperar la conexión."},
{"R_crServerSessionStateNotRecoverable","La conexión se ha perdido y no es posible recuperarla. El servidor marcó la conexión como irrecuperable. No se registró ningún intento para restaurar la conexión."},
{"R_crClientUnrecoverable","La conexión se ha perdido y no es posible recuperarla. El controlador cliente marcó la conexión como irrecuperable. No se registró ningún intento para restaurar la conexión."},
{"R_crClientSSLStateNotRecoverable","El servidor no conservó el cifrado SSL durante un intento de recuperación; no es posible recuperar la conexión."},
{"R_crCommandCannotTimeOut","Error al agotar el tiempo de espera de la solicitud y SQLServerConnection no existe"},
{"R_UnableLoadAuthDll","No se pueden cargar los DLL {0} de autenticación"},
};
}
