/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.codahalemetricspublisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCollapser;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;

public class HystrixCodaHaleMetricsPublisherCollapser
implements HystrixMetricsPublisherCollapser {
    private final HystrixCollapserKey key;
    private final HystrixCollapserMetrics metrics;
    private final HystrixCollapserProperties properties;
    private final MetricRegistry metricRegistry;
    private final String metricType;
    static final Logger logger = LoggerFactory.getLogger(HystrixCodaHaleMetricsPublisherCollapser.class);

    public HystrixCodaHaleMetricsPublisherCollapser(HystrixCollapserKey collapserKey, HystrixCollapserMetrics metrics, HystrixCollapserProperties properties, MetricRegistry metricRegistry) {
        this.key = collapserKey;
        this.metrics = metrics;
        this.properties = properties;
        this.metricRegistry = metricRegistry;
        this.metricType = this.key.name();
    }

    public void initialize() {
        this.metricRegistry.register(this.createMetricName("currentTime"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return System.currentTimeMillis();
            }
        });
        this.safelyCreateCumulativeCountForEvent("countRequestsBatched", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.COLLAPSER_REQUEST_BATCHED;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countBatches", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.COLLAPSER_BATCH;
            }
        });
        this.safelyCreateCumulativeCountForEvent("countResponsesFromCache", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.RESPONSE_FROM_CACHE;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingRequestsBatched", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.COLLAPSER_REQUEST_BATCHED;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingBatches", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.COLLAPSER_BATCH;
            }
        });
        this.safelyCreateRollingCountForEvent("rollingCountResponsesFromCache", new Func0<HystrixRollingNumberEvent>(){

            public HystrixRollingNumberEvent call() {
                return HystrixRollingNumberEvent.RESPONSE_FROM_CACHE;
            }
        });
        this.metricRegistry.register(this.createMetricName("batchSize_mean"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getBatchSizeMean();
            }
        });
        this.metricRegistry.register(this.createMetricName("batchSize_percentile_25"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(25.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("batchSize_percentile_50"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(50.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("batchSize_percentile_75"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(75.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("batchSize_percentile_90"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(90.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("batchSize_percentile_99"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(99.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("batchSize_percentile_995"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(99.5);
            }
        });
        this.metricRegistry.register(this.createMetricName("shardSize_mean"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getShardSizeMean();
            }
        });
        this.metricRegistry.register(this.createMetricName("shardSize_percentile_25"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getShardSizePercentile(25.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("shardSize_percentile_50"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getShardSizePercentile(50.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("shardSize_percentile_75"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getShardSizePercentile(75.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("shardSize_percentile_90"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getShardSizePercentile(90.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("shardSize_percentile_99"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getShardSizePercentile(99.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("shardSize_percentile_995"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getShardSizePercentile(99.5);
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_rollingStatisticalWindowInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCollapser.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_requestCacheEnabled"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCollapser.this.properties.requestCacheEnabled().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_maxRequestsInBatch"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCollapser.this.properties.maxRequestsInBatch().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_timerDelayInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCollapser.this.properties.timerDelayInMilliseconds().get();
            }
        });
    }

    protected String createMetricName(String name) {
        return MetricRegistry.name((String)"", (String[])new String[]{this.metricType, name});
    }

    protected void createCumulativeCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getCumulativeCount(event);
            }
        });
    }

    protected void safelyCreateCumulativeCountForEvent(final String name, final Func0<HystrixRollingNumberEvent> eventThunk) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                try {
                    return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getCumulativeCount((HystrixRollingNumberEvent)eventThunk.call());
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing CodaHale metrics, error looking up eventType for : {}.  Please check that all Hystrix versions are the same!", (Object)name);
                    return 0L;
                }
            }
        });
    }

    protected void createRollingCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getRollingCount(event);
            }
        });
    }

    protected void safelyCreateRollingCountForEvent(final String name, final Func0<HystrixRollingNumberEvent> eventThunk) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                try {
                    return HystrixCodaHaleMetricsPublisherCollapser.this.metrics.getRollingCount((HystrixRollingNumberEvent)eventThunk.call());
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing CodaHale metrics, error looking up eventType for : {}.  Please check that all Hystrix versions are the same!", (Object)name);
                    return 0L;
                }
            }
        });
    }
}

