/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ArrayTagSet;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopCounter;
import com.netflix.spectator.api.NoopDistributionSummary;
import com.netflix.spectator.api.NoopGauge;
import com.netflix.spectator.api.NoopTimer;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.RegistryConfig;
import com.netflix.spectator.api.SwapCounter;
import com.netflix.spectator.api.SwapDistributionSummary;
import com.netflix.spectator.api.SwapGauge;
import com.netflix.spectator.api.SwapTimer;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spectator.impl.Config;
import com.netflix.spectator.impl.Preconditions;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistry
implements Registry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Clock clock;
    private final RegistryConfig config;
    private final ConcurrentHashMap<Id, Meter> meters;
    private final ConcurrentHashMap<Id, Object> state;

    public AbstractRegistry(Clock clock) {
        this(clock, Config.defaultConfig());
    }

    public AbstractRegistry(Clock clock, RegistryConfig config) {
        this.clock = clock;
        this.config = config;
        this.meters = new ConcurrentHashMap();
        this.state = new ConcurrentHashMap();
    }

    protected abstract Counter newCounter(Id var1);

    private Counter createCounter(Id id) {
        return new SwapCounter(this.newCounter(id));
    }

    protected abstract DistributionSummary newDistributionSummary(Id var1);

    private DistributionSummary createDistributionSummary(Id id) {
        return new SwapDistributionSummary(this.newDistributionSummary(id));
    }

    protected abstract Timer newTimer(Id var1);

    private Timer createTimer(Id id) {
        return new SwapTimer(this.newTimer(id));
    }

    protected abstract Gauge newGauge(Id var1);

    private Gauge createGauge(Id id) {
        return new SwapGauge(this.newGauge(id));
    }

    @Override
    public final Clock clock() {
        return this.clock;
    }

    @Override
    public final RegistryConfig config() {
        return this.config;
    }

    @Override
    public final Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public final Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    private void logTypeError(Id id, Class<?> desired, Class<?> found) {
        String dtype = desired.getName();
        String ftype = found.getName();
        String msg = String.format("cannot access '%s' as a %s, it already exists as a %s", id, dtype, ftype);
        this.propagate(new IllegalStateException(msg));
    }

    private Meter compute(Meter m, Meter fallback) {
        return this.meters.size() >= this.config.maxNumberOfMeters() ? fallback : m;
    }

    @Override
    public void register(Meter meter) {
        PolledMeter.monitorMeter(this, meter);
    }

    @Override
    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    @Override
    public final Counter counter(Id id) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = Utils.computeIfAbsent(this.meters, id, i -> this.compute(this.createCounter((Id)i), NoopCounter.INSTANCE));
            if (!(m instanceof Counter)) {
                this.logTypeError(id, Counter.class, m.getClass());
                m = NoopCounter.INSTANCE;
            }
            return (Counter)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopCounter.INSTANCE;
        }
    }

    @Override
    public final DistributionSummary distributionSummary(Id id) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = Utils.computeIfAbsent(this.meters, id, i -> this.compute(this.createDistributionSummary((Id)i), NoopDistributionSummary.INSTANCE));
            if (!(m instanceof DistributionSummary)) {
                this.logTypeError(id, DistributionSummary.class, m.getClass());
                m = NoopDistributionSummary.INSTANCE;
            }
            return (DistributionSummary)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopDistributionSummary.INSTANCE;
        }
    }

    @Override
    public final Timer timer(Id id) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = Utils.computeIfAbsent(this.meters, id, i -> this.compute(this.createTimer((Id)i), NoopTimer.INSTANCE));
            if (!(m instanceof Timer)) {
                this.logTypeError(id, Timer.class, m.getClass());
                m = NoopTimer.INSTANCE;
            }
            return (Timer)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopTimer.INSTANCE;
        }
    }

    @Override
    public final Gauge gauge(Id id) {
        try {
            Preconditions.checkNotNull(id, "id");
            Meter m = Utils.computeIfAbsent(this.meters, id, i -> this.compute(this.createGauge((Id)i), NoopGauge.INSTANCE));
            if (!(m instanceof Gauge)) {
                this.logTypeError(id, Gauge.class, m.getClass());
                m = NoopGauge.INSTANCE;
            }
            return (Gauge)m;
        }
        catch (Exception e) {
            this.propagate(e);
            return NoopGauge.INSTANCE;
        }
    }

    @Override
    public final Meter get(Id id) {
        return this.meters.get(id);
    }

    @Override
    public final Iterator<Meter> iterator() {
        PolledMeter.update(this);
        return this.meters.values().iterator();
    }
}

