/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.operation;

import com.alibaba.fastjson.JSON;
import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperation {
    private static final Logger log = LoggerFactory.getLogger(FileOperation.class);
    private static Executor executor = Executors.newFixedThreadPool(20);

    public static File newFile(String fileUrl) {
        File file = new File(fileUrl);
        return file;
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        for (File newfile : file.listFiles()) {
            FileOperation.deleteFile(newfile);
        }
        return file.delete();
    }

    public static boolean deleteFile(String fileUrl) {
        File file = FileOperation.newFile(fileUrl);
        return FileOperation.deleteFile(file);
    }

    public static long getFileSize(String fileUrl) {
        File file = FileOperation.newFile(fileUrl);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public static long getFileSize(File file) {
        if (file == null) {
            return 0L;
        }
        return file.length();
    }

    public static boolean mkdir(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean mkdir(String fileUrl) {
        if (fileUrl == null) {
            return false;
        }
        File file = FileOperation.newFile(fileUrl);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int len = fileInputStream.read(buf);
            while (len != -1) {
                fileOutputStream.write(buf, 0, len);
                len = fileInputStream.read(buf);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        FileOperation.copyFile(in, out);
    }

    public static void copyFile(String srcUrl, String destUrl) throws IOException {
        if (srcUrl == null || destUrl == null) {
            return;
        }
        File srcFile = FileOperation.newFile(srcUrl);
        File descFile = FileOperation.newFile(destUrl);
        FileOperation.copyFile(srcFile, descFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unzip(File sourceFile, String destDirPath) {
        ZipFile zipFile = null;
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> fileEntryNameList = new ArrayList<String>();
        Enumeration<? extends ZipEntry> entries = null;
        try {
            try {
                ZipFile tempZipFile = new ZipFile(sourceFile);
                entries = tempZipFile.entries();
                log.info(JSON.toJSONString(entries));
                zipFile = new ZipFile(sourceFile);
                entries = zipFile.entries();
            }
            catch (IOException e) {
                throw new RuntimeException("unzip error from ZipUtils", e);
            }
            catch (IllegalArgumentException e) {
                try {
                    zipFile = new ZipFile(sourceFile, Charset.forName("GBK"));
                    entries = zipFile.entries();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("unzip error from ZipUtils", e);
            }
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String[] nameStrArr = entry.getName().split("/");
                String nameStr = "";
                for (int i = 0; i < nameStrArr.length; ++i) {
                    if ("".equals(nameStrArr[i])) continue;
                    nameStr = nameStr + "/" + nameStrArr[i];
                    set.add(nameStr);
                }
                log.info("\u89e3\u538b" + entry.getName());
                String zipPath = "/" + entry.getName();
                fileEntryNameList.add(zipPath);
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + File.separator + entry.getName();
                    File dir = FileOperation.newFile(dirPath);
                    dir.mkdir();
                    continue;
                }
                File targetFile = new File(destDirPath + "/" + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    int len;
                    targetFile.createNewFile();
                    is = zipFile.getInputStream(entry);
                    fos = new FileOutputStream(targetFile);
                    byte[] buf = new byte[2048];
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("\u89e3\u538b\u8fc7\u7a0b\u5931\u8d25", e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e1) {
                            log.error("\u5173\u95ed\u6d41\u5931\u8d25:" + e1);
                        }
                    }
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        log.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a" + e2);
                    }
                }
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        ArrayList<String> res = new ArrayList<String>(set);
        return res;
    }

    public static List<String> unrar(File sourceFile, String destDirPath) throws Exception {
        File destDir = new File(destDirPath);
        HashSet<String> set = new HashSet<String>();
        Archive archive = null;
        FileOutputStream fos = null;
        System.out.println("Starting \u5f00\u59cb\u89e3\u538b...");
        try {
            archive = new Archive(sourceFile);
            FileHeader fh = archive.nextFileHeader();
            int count = 0;
            File destFileName = null;
            while (fh != null) {
                set.add("/" + fh.getFileName());
                System.out.println(++count + ") " + fh.getFileName());
                String compressFileName = fh.getFileName().trim();
                destFileName = new File(destDir.getAbsolutePath() + "/" + compressFileName);
                if (fh.isDirectory()) {
                    if (!destFileName.exists()) {
                        destFileName.mkdirs();
                    }
                    fh = archive.nextFileHeader();
                    continue;
                }
                if (!destFileName.getParentFile().exists()) {
                    destFileName.getParentFile().mkdirs();
                }
                fos = new FileOutputStream(destFileName);
                archive.extractFile(fh, (OutputStream)fos);
                fos.close();
                fos = null;
                fh = archive.nextFileHeader();
            }
            archive.close();
            archive = null;
            System.out.println("Finished \u89e3\u538b\u5b8c\u6210!");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            if (archive != null) {
                try {
                    archive.close();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d41\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        ArrayList<String> res = new ArrayList<String>(set);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDataToFile(String filePath, String fileName, String data) {
        File file;
        BufferedWriter writer = null;
        File dir = new File(filePath);
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(file = new File(filePath + fileName)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
            writer.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("\u6587\u4ef6\u5199\u5165\u6210\u529f\uff01");
    }
}

