/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.operation;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageOperation {
    private static final Logger log = LoggerFactory.getLogger(ImageOperation.class);

    public static void leftTotation(File inFile, File outFile, int angle) throws IOException {
        Thumbnails.of((File[])new File[]{inFile}).scale(1.0).outputQuality(1.0f).rotate((double)(-angle)).toFile(outFile);
    }

    public static void rightTotation(File inFile, File outFile, int angle) throws IOException {
        Thumbnails.of((File[])new File[]{inFile}).scale(1.0).outputQuality(1.0f).rotate((double)angle).toFile(outFile);
    }

    public static void thumbnailsImage(File inFile, File outFile, int width, int height) throws IOException {
        Thumbnails.of((File[])new File[]{inFile}).size(width, height).toFile(outFile);
    }

    public static InputStream thumbnailsImage(InputStream inputStream, File outFile, int width, int height) throws IOException {
        File parentFile = outFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        int oriHeight = bufferedImage.getHeight();
        int oriWidth = bufferedImage.getWidth();
        if (oriHeight <= height || oriWidth <= width) {
            ImageIO.write((RenderedImage)bufferedImage, FilenameUtils.getExtension((String)outFile.getName()), outFile);
        } else {
            if (oriHeight < oriWidth) {
                Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).outputQuality(1.0f).scale(1.0).sourceRegion((Position)Positions.CENTER, oriHeight, oriHeight).toFile(outFile);
            } else {
                Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).outputQuality(1.0f).scale(1.0).sourceRegion((Position)Positions.CENTER, oriWidth, oriWidth).toFile(outFile);
            }
            Thumbnails.of((BufferedImage[])new BufferedImage[]{ImageIO.read(outFile)}).outputQuality(0.9).size(width, height).toFile(outFile);
        }
        return new FileInputStream(outFile);
    }

    public static String getFileExtendName(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

