/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgUtil {
    private static Logger logger = LoggerFactory.getLogger(ImgUtil.class);

    public static byte[] compressPicForScale(byte[] imageBytes, long desFileSize, String imageId) {
        if (imageBytes == null || imageBytes.length <= 0 || (long)imageBytes.length < desFileSize * 1024L) {
            return imageBytes;
        }
        long srcSize = imageBytes.length;
        double accuracy = 0.4;
        try {
            while ((long)imageBytes.length > desFileSize * 1024L) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
                Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(accuracy).outputQuality(accuracy).toOutputStream((OutputStream)outputStream);
                imageBytes = outputStream.toByteArray();
            }
            logger.info("\u3010\u56fe\u7247\u538b\u7f29\u3011imageId={} | \u56fe\u7247\u539f\u5927\u5c0f={}kb | \u538b\u7f29\u540e\u5927\u5c0f={}kb", new Object[]{imageId, srcSize / 1024L, imageBytes.length / 1024});
        }
        catch (Exception e) {
            logger.error("\u3010\u56fe\u7247\u538b\u7f29\u3011msg=\u56fe\u7247\u538b\u7f29\u5931\u8d25!", (Throwable)e);
        }
        return imageBytes;
    }

    private static double getAccuracy(long size) {
        double accuracy = size < 900L ? 0.5 : (size < 2047L ? 0.6 : (size < 3275L ? 0.44 : 0.4));
        return accuracy;
    }
}

