/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.common.util.math;

import com.qiwenshare.common.util.math.ArithHelper;
import java.util.Collections;
import java.util.Stack;

public class CalculatorUtils {
    private Stack<String> postfixStack = new Stack();
    private Stack<Character> opStack = new Stack();
    private int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double conversion(String expression) {
        expression = expression.replaceAll(" ", "");
        double result = 0.0;
        CalculatorUtils cal = new CalculatorUtils();
        try {
            expression = CalculatorUtils.transform(expression);
            result = cal.calculate(expression);
        }
        catch (Exception e) {
            return Double.NaN;
        }
        return result;
    }

    private static String transform(String expression) {
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != '-') continue;
            if (i == 0) {
                arr[i] = 126;
                continue;
            }
            char c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(' && c != 'E' && c != 'e') continue;
            arr[i] = 126;
        }
        if (arr[0] == '~' || arr[1] == '(') {
            arr[0] = 45;
            return "0" + new String(arr);
        }
        return new String(arr);
    }

    public double calculate(String expression) {
        Stack<String> resultStack = new Stack<String>();
        this.prepare(expression);
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String currentValue = this.postfixStack.pop();
            if (!this.isOperator(currentValue.charAt(0))) {
                currentValue = currentValue.replace("~", "-");
                resultStack.push(currentValue);
                continue;
            }
            String secondValue = (String)resultStack.pop();
            String firstValue = (String)resultStack.pop();
            firstValue = firstValue.replace("~", "-");
            secondValue = secondValue.replace("~", "-");
            String tempResult = this.calculate(firstValue, secondValue, currentValue.charAt(0));
            resultStack.push(tempResult);
        }
        return Double.valueOf((String)resultStack.pop());
    }

    private void prepare(String expression) {
        this.opStack.push(Character.valueOf(','));
        char[] arr = expression.toCharArray();
        int currentIndex = 0;
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            char currentOp = arr[i];
            if (this.isOperator(currentOp)) {
                if (count > 0) {
                    this.postfixStack.push(new String(arr, currentIndex, count));
                }
                char peekOp = this.opStack.peek().charValue();
                if (currentOp == ')') {
                    while (this.opStack.peek().charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (currentOp != '(' && peekOp != ',' && this.compare(currentOp, peekOp)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        peekOp = this.opStack.peek().charValue();
                    }
                    this.opStack.push(Character.valueOf(currentOp));
                }
                count = 0;
                currentIndex = i + 1;
                continue;
            }
            ++count;
        }
        if (count > 1 || count == 1 && !this.isOperator(arr[currentIndex])) {
            this.postfixStack.push(new String(arr, currentIndex, count));
        }
        while (this.opStack.peek().charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    private boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '(' || c == ')';
    }

    public boolean compare(char cur, char peek) {
        boolean result = false;
        if (this.operatPriority[peek - 40] >= this.operatPriority[cur - 40]) {
            result = true;
        }
        return result;
    }

    private String calculate(String firstValue, String secondValue, char currentOp) {
        String result = "";
        switch (currentOp) {
            case '+': {
                result = String.valueOf(ArithHelper.add(firstValue, secondValue));
                break;
            }
            case '-': {
                result = String.valueOf(ArithHelper.sub(firstValue, secondValue));
                break;
            }
            case '*': {
                result = String.valueOf(ArithHelper.mul(firstValue, secondValue));
                break;
            }
            case '/': {
                result = String.valueOf(ArithHelper.div(firstValue, secondValue));
            }
        }
        return result;
    }
}

