/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        if (format != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got " + (Object)((Object)format));
        }
        return super.encode(contents, format, width, height, hints);
    }

    @Override
    public boolean[] encode(String contents) {
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        int i = 0;
        while (i < length) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(contents.charAt(i));
            if (indexInString < 0) {
                length = (contents = Code39Writer.tryToConvertToExtendedMode(contents)).length();
                if (length <= 80) break;
                throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length + " (extended full ASCII mode)");
            }
            ++i;
        }
        int[] widths = new int[9];
        int codeWidth = 25 + length;
        int i2 = 0;
        while (i2 < length) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(contents.charAt(i2));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[indexInString], widths);
            int[] nArray = widths;
            int n = widths.length;
            int n2 = 0;
            while (n2 < n) {
                int width = nArray[n2];
                codeWidth += width;
                ++n2;
            }
            ++i2;
        }
        boolean[] result = new boolean[codeWidth];
        Code39Writer.toIntArray(148, widths);
        int pos = Code39Writer.appendPattern(result, 0, widths, true);
        int[] narrowWhite = new int[]{1};
        pos += Code39Writer.appendPattern(result, pos, narrowWhite, false);
        int i3 = 0;
        while (i3 < length) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(contents.charAt(i3));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[indexInString], widths);
            pos += Code39Writer.appendPattern(result, pos, widths, true);
            pos += Code39Writer.appendPattern(result, pos, narrowWhite, false);
            ++i3;
        }
        Code39Writer.toIntArray(148, widths);
        Code39Writer.appendPattern(result, pos, widths, true);
        return result;
    }

    private static void toIntArray(int a, int[] toReturn) {
        int i = 0;
        while (i < 9) {
            int temp = a & 1 << 8 - i;
            toReturn[i] = temp == 0 ? 1 : 2;
            ++i;
        }
    }

    private static String tryToConvertToExtendedMode(String contents) {
        int length = contents.length();
        StringBuilder extendedContent = new StringBuilder();
        int i = 0;
        while (i < length) {
            char character = contents.charAt(i);
            switch (character) {
                case '\u0000': {
                    extendedContent.append("%U");
                    break;
                }
                case ' ': 
                case '-': 
                case '.': {
                    extendedContent.append(character);
                    break;
                }
                case '@': {
                    extendedContent.append("%V");
                    break;
                }
                case '`': {
                    extendedContent.append("%W");
                    break;
                }
                default: {
                    if (character <= '\u001a') {
                        extendedContent.append('$');
                        extendedContent.append((char)(65 + (character - '\u0001')));
                        break;
                    }
                    if (character < ' ') {
                        extendedContent.append('%');
                        extendedContent.append((char)(65 + (character - 27)));
                        break;
                    }
                    if (character <= ',' || character == '/' || character == ':') {
                        extendedContent.append('/');
                        extendedContent.append((char)(65 + (character - 33)));
                        break;
                    }
                    if (character <= '9') {
                        extendedContent.append((char)(48 + (character - 48)));
                        break;
                    }
                    if (character <= '?') {
                        extendedContent.append('%');
                        extendedContent.append((char)(70 + (character - 59)));
                        break;
                    }
                    if (character <= 'Z') {
                        extendedContent.append((char)(65 + (character - 65)));
                        break;
                    }
                    if (character <= '_') {
                        extendedContent.append('%');
                        extendedContent.append((char)(75 + (character - 91)));
                        break;
                    }
                    if (character <= 'z') {
                        extendedContent.append('+');
                        extendedContent.append((char)(65 + (character - 97)));
                        break;
                    }
                    if (character <= '\u007f') {
                        extendedContent.append('%');
                        extendedContent.append((char)(80 + (character - 123)));
                        break;
                    }
                    throw new IllegalArgumentException("Requested content contains a non-encodable character: '" + contents.charAt(i) + "'");
                }
            }
            ++i;
        }
        return extendedContent.toString();
    }
}

