/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public class Code93Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        if (format != BarcodeFormat.CODE_93) {
            throw new IllegalArgumentException("Can only encode CODE_93, but got " + (Object)((Object)format));
        }
        return super.encode(contents, format, width, height, hints);
    }

    @Override
    public boolean[] encode(String contents) {
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        int[] widths = new int[9];
        int codeWidth = (contents.length() + 2 + 2) * 9 + 1;
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], widths);
        boolean[] result = new boolean[codeWidth];
        int pos = Code93Writer.appendPattern(result, 0, widths);
        int i = 0;
        while (i < length) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[indexInString], widths);
            pos += Code93Writer.appendPattern(result, pos, widths);
            ++i;
        }
        int check1 = Code93Writer.computeChecksumIndex(contents, 20);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[check1], widths);
        pos += Code93Writer.appendPattern(result, pos, widths);
        contents = String.valueOf(contents) + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(check1);
        int check2 = Code93Writer.computeChecksumIndex(contents, 15);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[check2], widths);
        pos += Code93Writer.appendPattern(result, pos, widths);
        Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], widths);
        pos += Code93Writer.appendPattern(result, pos, widths);
        result[pos] = true;
        return result;
    }

    private static void toIntArray(int a, int[] toReturn) {
        int i = 0;
        while (i < 9) {
            int temp = a & 1 << 8 - i;
            toReturn[i] = temp == 0 ? 0 : 1;
            ++i;
        }
    }

    @Deprecated
    protected static int appendPattern(boolean[] target, int pos, int[] pattern, boolean startColor) {
        return Code93Writer.appendPattern(target, pos, pattern);
    }

    private static int appendPattern(boolean[] target, int pos, int[] pattern) {
        int[] nArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            int bit = nArray[n2];
            target[pos++] = bit != 0;
            ++n2;
        }
        return 9;
    }

    private static int computeChecksumIndex(String contents, int maxWeight) {
        int weight = 1;
        int total = 0;
        int i = contents.length() - 1;
        while (i >= 0) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            total += indexInString * weight;
            if (++weight > maxWeight) {
                weight = 1;
            }
            --i;
        }
        return total % 47;
    }
}

