/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 97;
    private final BitMatrix image;
    private final List<FinderPattern> possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix image) {
        this(image, null);
    }

    public FinderPatternFinder(BitMatrix image, ResultPointCallback resultPointCallback) {
        this.image = image;
        this.possibleCenters = new ArrayList<FinderPattern>();
        this.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List<FinderPattern> getPossibleCenters() {
        return this.possibleCenters;
    }

    final FinderPatternInfo find(Map<DecodeHintType, ?> hints) throws NotFoundException {
        boolean tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER);
        int maxI = this.image.getHeight();
        int maxJ = this.image.getWidth();
        int iSkip = 3 * maxI / 388;
        if (iSkip < 3 || tryHarder) {
            iSkip = 3;
        }
        boolean done = false;
        int[] stateCount = new int[5];
        int i = iSkip - 1;
        while (i < maxI && !done) {
            boolean confirmed;
            this.clearCounts(stateCount);
            int currentState = 0;
            int j = 0;
            while (j < maxJ) {
                if (this.image.get(j, i)) {
                    if (currentState & true) {
                        // empty if block
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                } else if (!(currentState & true)) {
                    if (currentState == 4) {
                        if (FinderPatternFinder.foundPatternCross(stateCount)) {
                            boolean confirmed2 = this.handlePossibleCenter(stateCount, i, j);
                            if (!confirmed2) {
                                this.shiftCounts2(stateCount);
                                currentState = 3;
                            } else {
                                iSkip = 2;
                                if (this.hasSkipped) {
                                    done = this.haveMultiplyConfirmedCenters();
                                } else {
                                    int rowSkip = this.findRowSkip();
                                    if (rowSkip > stateCount[2]) {
                                        i += rowSkip - stateCount[2] - iSkip;
                                        j = maxJ - 1;
                                    }
                                }
                                currentState = 0;
                                this.clearCounts(stateCount);
                            }
                        } else {
                            this.shiftCounts2(stateCount);
                            currentState = 3;
                        }
                    } else {
                        int n = ++currentState;
                        stateCount[n] = stateCount[n] + 1;
                    }
                } else {
                    int n = currentState;
                    stateCount[n] = stateCount[n] + 1;
                }
                ++j;
            }
            if (FinderPatternFinder.foundPatternCross(stateCount) && (confirmed = this.handlePossibleCenter(stateCount, i, maxJ))) {
                iSkip = stateCount[0];
                if (this.hasSkipped) {
                    done = this.haveMultiplyConfirmedCenters();
                }
            }
            i += iSkip;
        }
        ResultPoint[] patternInfo = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(patternInfo);
        return new FinderPatternInfo((FinderPattern[])patternInfo);
    }

    private static float centerFromEnd(int[] stateCount, int end) {
        return (float)(end - stateCount[4] - stateCount[3]) - (float)stateCount[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] stateCount) {
        int totalModuleSize = 0;
        int i = 0;
        while (i < 5) {
            int count = stateCount[i];
            if (count == 0) {
                return false;
            }
            totalModuleSize += count;
            ++i;
        }
        if (totalModuleSize < 7) {
            return false;
        }
        float moduleSize = (float)totalModuleSize / 7.0f;
        float maxVariance = moduleSize / 2.0f;
        return Math.abs(moduleSize - (float)stateCount[0]) < maxVariance && Math.abs(moduleSize - (float)stateCount[1]) < maxVariance && Math.abs(3.0f * moduleSize - (float)stateCount[2]) < 3.0f * maxVariance && Math.abs(moduleSize - (float)stateCount[3]) < maxVariance && Math.abs(moduleSize - (float)stateCount[4]) < maxVariance;
    }

    protected static boolean foundPatternDiagonal(int[] stateCount) {
        int totalModuleSize = 0;
        int i = 0;
        while (i < 5) {
            int count = stateCount[i];
            if (count == 0) {
                return false;
            }
            totalModuleSize += count;
            ++i;
        }
        if (totalModuleSize < 7) {
            return false;
        }
        float moduleSize = (float)totalModuleSize / 7.0f;
        float maxVariance = moduleSize / 1.333f;
        return Math.abs(moduleSize - (float)stateCount[0]) < maxVariance && Math.abs(moduleSize - (float)stateCount[1]) < maxVariance && Math.abs(3.0f * moduleSize - (float)stateCount[2]) < 3.0f * maxVariance && Math.abs(moduleSize - (float)stateCount[3]) < maxVariance && Math.abs(moduleSize - (float)stateCount[4]) < maxVariance;
    }

    private int[] getCrossCheckStateCount() {
        this.clearCounts(this.crossCheckStateCount);
        return this.crossCheckStateCount;
    }

    protected final void clearCounts(int[] counts) {
        int x = 0;
        while (x < counts.length) {
            counts[x] = 0;
            ++x;
        }
    }

    protected final void shiftCounts2(int[] stateCount) {
        stateCount[0] = stateCount[2];
        stateCount[1] = stateCount[3];
        stateCount[2] = stateCount[4];
        stateCount[3] = 1;
        stateCount[4] = 0;
    }

    /*
     * Unable to fully structure code
     */
    private boolean crossCheckDiagonal(int centerI, int centerJ) {
        stateCount = this.getCrossCheckStateCount();
        i = 0;
        while (centerI >= i && centerJ >= i && this.image.get(centerJ - i, centerI - i)) {
            stateCount[2] = stateCount[2] + 1;
            ++i;
        }
        if (stateCount[2] != 0) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            stateCount[1] = stateCount[1] + 1;
            ++i;
lbl11:
            // 2 sources

            ** while (centerI >= i && centerJ >= i && !this.image.get((int)(centerJ - i), (int)(centerI - i)))
        }
lbl12:
        // 1 sources

        if (stateCount[1] != 0) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            stateCount[0] = stateCount[0] + 1;
            ++i;
lbl16:
            // 2 sources

            ** while (centerI >= i && centerJ >= i && this.image.get((int)(centerJ - i), (int)(centerI - i)))
        }
lbl17:
        // 1 sources

        if (stateCount[0] == 0) {
            return false;
        }
        maxI = this.image.getHeight();
        maxJ = this.image.getWidth();
        i = 1;
        while (centerI + i < maxI && centerJ + i < maxJ && this.image.get(centerJ + i, centerI + i)) {
            stateCount[2] = stateCount[2] + 1;
            ++i;
        }
        while (centerI + i < maxI && centerJ + i < maxJ && !this.image.get(centerJ + i, centerI + i)) {
            stateCount[3] = stateCount[3] + 1;
            ++i;
        }
        if (stateCount[3] != 0) ** GOTO lbl34
        return false;
lbl-1000:
        // 1 sources

        {
            stateCount[4] = stateCount[4] + 1;
            ++i;
lbl34:
            // 2 sources

            ** while (centerI + i < maxI && centerJ + i < maxJ && this.image.get((int)(centerJ + i), (int)(centerI + i)))
        }
lbl35:
        // 1 sources

        if (stateCount[4] == 0) {
            return false;
        }
        return FinderPatternFinder.foundPatternDiagonal(stateCount);
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckVertical(int startI, int centerJ, int maxCount, int originalStateCountTotal) {
        image = this.image;
        maxI = image.getHeight();
        stateCount = this.getCrossCheckStateCount();
        i = startI;
        while (i >= 0 && image.get(centerJ, i)) {
            stateCount[2] = stateCount[2] + 1;
            --i;
        }
        if (i >= 0) ** GOTO lbl13
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[1] = stateCount[1] + 1;
            --i;
lbl13:
            // 2 sources

            ** while (i >= 0 && !image.get((int)centerJ, (int)i) && stateCount[1] <= maxCount)
        }
lbl14:
        // 1 sources

        if (i >= 0 && stateCount[1] <= maxCount) ** GOTO lbl18
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[0] = stateCount[0] + 1;
            --i;
lbl18:
            // 2 sources

            ** while (i >= 0 && image.get((int)centerJ, (int)i) && stateCount[0] <= maxCount)
        }
lbl19:
        // 1 sources

        if (stateCount[0] > maxCount) {
            return NaNf;
        }
        i = startI + 1;
        while (i < maxI && image.get(centerJ, i)) {
            stateCount[2] = stateCount[2] + 1;
            ++i;
        }
        if (i != maxI) ** GOTO lbl30
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[3] = stateCount[3] + 1;
            ++i;
lbl30:
            // 2 sources

            ** while (i < maxI && !image.get((int)centerJ, (int)i) && stateCount[3] < maxCount)
        }
lbl31:
        // 1 sources

        if (i != maxI && stateCount[3] < maxCount) ** GOTO lbl35
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[4] = stateCount[4] + 1;
            ++i;
lbl35:
            // 2 sources

            ** while (i < maxI && image.get((int)centerJ, (int)i) && stateCount[4] < maxCount)
        }
lbl36:
        // 1 sources

        if (stateCount[4] >= maxCount) {
            return NaNf;
        }
        stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= 2 * originalStateCountTotal) {
            return NaNf;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) != false ? FinderPatternFinder.centerFromEnd(stateCount, i) : NaNf;
    }

    /*
     * Unable to fully structure code
     */
    private float crossCheckHorizontal(int startJ, int centerI, int maxCount, int originalStateCountTotal) {
        image = this.image;
        maxJ = image.getWidth();
        stateCount = this.getCrossCheckStateCount();
        j = startJ;
        while (j >= 0 && image.get(j, centerI)) {
            stateCount[2] = stateCount[2] + 1;
            --j;
        }
        if (j >= 0) ** GOTO lbl13
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[1] = stateCount[1] + 1;
            --j;
lbl13:
            // 2 sources

            ** while (j >= 0 && !image.get((int)j, (int)centerI) && stateCount[1] <= maxCount)
        }
lbl14:
        // 1 sources

        if (j >= 0 && stateCount[1] <= maxCount) ** GOTO lbl18
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[0] = stateCount[0] + 1;
            --j;
lbl18:
            // 2 sources

            ** while (j >= 0 && image.get((int)j, (int)centerI) && stateCount[0] <= maxCount)
        }
lbl19:
        // 1 sources

        if (stateCount[0] > maxCount) {
            return NaNf;
        }
        j = startJ + 1;
        while (j < maxJ && image.get(j, centerI)) {
            stateCount[2] = stateCount[2] + 1;
            ++j;
        }
        if (j != maxJ) ** GOTO lbl30
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[3] = stateCount[3] + 1;
            ++j;
lbl30:
            // 2 sources

            ** while (j < maxJ && !image.get((int)j, (int)centerI) && stateCount[3] < maxCount)
        }
lbl31:
        // 1 sources

        if (j != maxJ && stateCount[3] < maxCount) ** GOTO lbl35
        return NaNf;
lbl-1000:
        // 1 sources

        {
            stateCount[4] = stateCount[4] + 1;
            ++j;
lbl35:
            // 2 sources

            ** while (j < maxJ && image.get((int)j, (int)centerI) && stateCount[4] < maxCount)
        }
lbl36:
        // 1 sources

        if (stateCount[4] >= maxCount) {
            return NaNf;
        }
        stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= originalStateCountTotal) {
            return NaNf;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) != false ? FinderPatternFinder.centerFromEnd(stateCount, j) : NaNf;
    }

    @Deprecated
    protected final boolean handlePossibleCenter(int[] stateCount, int i, int j, boolean pureBarcode) {
        return this.handlePossibleCenter(stateCount, i, j);
    }

    protected final boolean handlePossibleCenter(int[] stateCount, int i, int j) {
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        float centerJ = FinderPatternFinder.centerFromEnd(stateCount, j);
        float centerI = this.crossCheckVertical(i, (int)centerJ, stateCount[2], stateCountTotal);
        if (!Float.isNaN(centerI) && !Float.isNaN(centerJ = this.crossCheckHorizontal((int)centerJ, (int)centerI, stateCount[2], stateCountTotal)) && this.crossCheckDiagonal((int)centerI, (int)centerJ)) {
            float estimatedModuleSize = (float)stateCountTotal / 7.0f;
            boolean found = false;
            int index = 0;
            while (index < this.possibleCenters.size()) {
                FinderPattern center = this.possibleCenters.get(index);
                if (center.aboutEquals(estimatedModuleSize, centerI, centerJ)) {
                    this.possibleCenters.set(index, center.combineEstimate(centerI, centerJ, estimatedModuleSize));
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                FinderPattern point = new FinderPattern(centerJ, centerI, estimatedModuleSize);
                this.possibleCenters.add(point);
                if (this.resultPointCallback != null) {
                    this.resultPointCallback.foundPossibleResultPoint(point);
                }
            }
            return true;
        }
        return false;
    }

    private int findRowSkip() {
        int max = this.possibleCenters.size();
        if (max <= 1) {
            return 0;
        }
        FinderPattern firstConfirmedCenter = null;
        for (FinderPattern center : this.possibleCenters) {
            if (center.getCount() < 2) continue;
            if (firstConfirmedCenter == null) {
                firstConfirmedCenter = center;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(firstConfirmedCenter.getX() - center.getX()) - Math.abs(firstConfirmedCenter.getY() - center.getY())) / 2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        int confirmedCount = 0;
        float totalModuleSize = 0.0f;
        int max = this.possibleCenters.size();
        for (FinderPattern pattern : this.possibleCenters) {
            if (pattern.getCount() < 2) continue;
            ++confirmedCount;
            totalModuleSize += pattern.getEstimatedModuleSize();
        }
        if (confirmedCount < 3) {
            return false;
        }
        float average = totalModuleSize / (float)max;
        float totalDeviation = 0.0f;
        for (FinderPattern pattern : this.possibleCenters) {
            totalDeviation += Math.abs(pattern.getEstimatedModuleSize() - average);
        }
        return totalDeviation <= 0.05f * totalModuleSize;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        float totalModuleSize;
        int startSize = this.possibleCenters.size();
        if (startSize < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (startSize > 3) {
            totalModuleSize = 0.0f;
            float square = 0.0f;
            for (FinderPattern center : this.possibleCenters) {
                float size = center.getEstimatedModuleSize();
                totalModuleSize += size;
                square += size * size;
            }
            float average = totalModuleSize / (float)startSize;
            float stdDev = (float)Math.sqrt(square / (float)startSize - average * average);
            Collections.sort(this.possibleCenters, new FurthestFromAverageComparator(average));
            float limit = Math.max(0.2f * average, stdDev);
            int i = 0;
            while (i < this.possibleCenters.size() && this.possibleCenters.size() > 3) {
                FinderPattern pattern = this.possibleCenters.get(i);
                if (Math.abs(pattern.getEstimatedModuleSize() - average) > limit) {
                    this.possibleCenters.remove(i);
                    --i;
                }
                ++i;
            }
        }
        if (this.possibleCenters.size() > 3) {
            totalModuleSize = 0.0f;
            for (FinderPattern possibleCenter : this.possibleCenters) {
                totalModuleSize += possibleCenter.getEstimatedModuleSize();
            }
            float average = totalModuleSize / (float)this.possibleCenters.size();
            Collections.sort(this.possibleCenters, new CenterComparator(average));
            this.possibleCenters.subList(3, this.possibleCenters.size()).clear();
        }
        return new FinderPattern[]{this.possibleCenters.get(0), this.possibleCenters.get(1), this.possibleCenters.get(2)};
    }

    private static final class CenterComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private final float average;

        private CenterComparator(float f) {
            this.average = f;
        }

        @Override
        public int compare(FinderPattern center1, FinderPattern center2) {
            int countCompare;
            int y;
            int x = center2.getCount();
            int n = x < (y = center1.getCount()) ? -1 : (countCompare = x == y ? 0 : 1);
            if (countCompare == 0) {
                return Float.compare(Math.abs(center1.getEstimatedModuleSize() - this.average), Math.abs(center2.getEstimatedModuleSize() - this.average));
            }
            return countCompare;
        }
    }

    private static final class FurthestFromAverageComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private final float average;

        private FurthestFromAverageComparator(float f) {
            this.average = f;
        }

        @Override
        public int compare(FinderPattern center1, FinderPattern center2) {
            return Float.compare(Math.abs(center2.getEstimatedModuleSize() - this.average), Math.abs(center1.getEstimatedModuleSize() - this.average));
        }
    }
}

