/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix matrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(matrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(matrix, false);
    }

    static int applyMaskPenaltyRule2(ByteMatrix matrix) {
        int penalty = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int y = 0;
        while (y < height - 1) {
            byte[] arrayY = array[y];
            int x = 0;
            while (x < width - 1) {
                byte value = arrayY[x];
                if (value == arrayY[x + 1] && value == array[y + 1][x] && value == array[y + 1][x + 1]) {
                    ++penalty;
                }
                ++x;
            }
            ++y;
        }
        return 3 * penalty;
    }

    static int applyMaskPenaltyRule3(ByteMatrix matrix) {
        int numPenalties = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                byte[] arrayY = array[y];
                if (x + 6 < width && arrayY[x] == 1 && arrayY[x + 1] == 0 && arrayY[x + 2] == 1 && arrayY[x + 3] == 1 && arrayY[x + 4] == 1 && arrayY[x + 5] == 0 && arrayY[x + 6] == 1 && (MaskUtil.isWhiteHorizontal(arrayY, x - 4, x) || MaskUtil.isWhiteHorizontal(arrayY, x + 7, x + 11))) {
                    ++numPenalties;
                }
                if (y + 6 < height && array[y][x] == 1 && array[y + 1][x] == 0 && array[y + 2][x] == 1 && array[y + 3][x] == 1 && array[y + 4][x] == 1 && array[y + 5][x] == 0 && array[y + 6][x] == 1 && (MaskUtil.isWhiteVertical(array, x, y - 4, y) || MaskUtil.isWhiteVertical(array, x, y + 7, y + 11))) {
                    ++numPenalties;
                }
                ++x;
            }
            ++y;
        }
        return numPenalties * 40;
    }

    private static boolean isWhiteHorizontal(byte[] rowArray, int from, int to) {
        from = Math.max(from, 0);
        to = Math.min(to, rowArray.length);
        int i = from;
        while (i < to) {
            if (rowArray[i] == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isWhiteVertical(byte[][] array, int col, int from, int to) {
        from = Math.max(from, 0);
        to = Math.min(to, array.length);
        int i = from;
        while (i < to) {
            if (array[i][col] == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static int applyMaskPenaltyRule4(ByteMatrix matrix) {
        int numDarkCells = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int y = 0;
        while (y < height) {
            byte[] arrayY = array[y];
            int x = 0;
            while (x < width) {
                if (arrayY[x] == 1) {
                    ++numDarkCells;
                }
                ++x;
            }
            ++y;
        }
        int numTotalCells = matrix.getHeight() * matrix.getWidth();
        int fivePercentVariances = Math.abs(numDarkCells * 2 - numTotalCells) * 10 / numTotalCells;
        return fivePercentVariances * 10;
    }

    static boolean getDataMaskBit(int maskPattern, int x, int y) {
        int intermediate;
        switch (maskPattern) {
            case 0: {
                intermediate = y + x & 1;
                break;
            }
            case 1: {
                intermediate = y & 1;
                break;
            }
            case 2: {
                intermediate = x % 3;
                break;
            }
            case 3: {
                intermediate = (y + x) % 3;
                break;
            }
            case 4: {
                intermediate = y / 2 + x / 3 & 1;
                break;
            }
            case 5: {
                int temp = y * x;
                intermediate = (temp & 1) + temp % 3;
                break;
            }
            case 6: {
                int temp = y * x;
                intermediate = (temp & 1) + temp % 3 & 1;
                break;
            }
            case 7: {
                int temp = y * x;
                intermediate = temp % 3 + (y + x & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + maskPattern);
            }
        }
        return intermediate == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix matrix, boolean isHorizontal) {
        int penalty = 0;
        int iLimit = isHorizontal ? matrix.getHeight() : matrix.getWidth();
        int jLimit = isHorizontal ? matrix.getWidth() : matrix.getHeight();
        byte[][] array = matrix.getArray();
        int i = 0;
        while (i < iLimit) {
            int numSameBitCells = 0;
            byte prevBit = -1;
            int j = 0;
            while (j < jLimit) {
                byte bit;
                byte by = bit = isHorizontal ? array[i][j] : array[j][i];
                if (bit == prevBit) {
                    ++numSameBitCells;
                } else {
                    if (numSameBitCells >= 5) {
                        penalty += 3 + (numSameBitCells - 5);
                    }
                    numSameBitCells = 1;
                    prevBit = bit;
                }
                ++j;
            }
            if (numSameBitCells >= 5) {
                penalty += 3 + (numSameBitCells - 5);
            }
            ++i;
        }
        return penalty;
    }
}

