/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.utils;

import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.resource.ClientResources;

public class ClientBuilder {
    private final RedisURI uri;
    private boolean cluster;
    private ClientOptions options;
    private ClientResources resources;

    public ClientBuilder(RedisURI uri) {
        this.uri = uri;
    }

    public AbstractRedisClient build() {
        if (this.cluster) {
            RedisModulesClusterClient client = this.clusterClient();
            if (this.options != null) {
                client.setOptions((ClusterClientOptions)this.options);
            }
            return client;
        }
        RedisModulesClient client = this.client();
        if (this.options != null) {
            client.setOptions(this.options);
        }
        return client;
    }

    private RedisModulesClient client() {
        if (this.resources == null) {
            return RedisModulesClient.create((RedisURI)this.uri);
        }
        return RedisModulesClient.create((ClientResources)this.resources, (RedisURI)this.uri);
    }

    private RedisModulesClusterClient clusterClient() {
        if (this.resources == null) {
            return RedisModulesClusterClient.create((RedisURI)this.uri);
        }
        return RedisModulesClusterClient.create((ClientResources)this.resources, (RedisURI)this.uri);
    }

    public ClientBuilder cluster() {
        return this.cluster(true);
    }

    public ClientBuilder cluster(boolean cluster) {
        this.cluster = cluster;
        return this;
    }

    public ClientBuilder resources(ClientResources resources) {
        this.resources = resources;
        return this;
    }

    public ClientBuilder options(ClientOptions options) {
        this.options = options;
        return this;
    }

    public static ClientBuilder of(RedisURI uri) {
        return new ClientBuilder(uri);
    }
}

