/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.utils;

import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import com.redis.lettucemod.cluster.api.StatefulRedisModulesClusterConnection;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.function.Supplier;

public class ConnectionBuilder {
    private final AbstractRedisClient client;
    private ReadFrom readFrom;

    public ConnectionBuilder(AbstractRedisClient client) {
        this.client = client;
    }

    public static ConnectionBuilder client(AbstractRedisClient client) {
        return new ConnectionBuilder(client);
    }

    public ConnectionBuilder readFrom(ReadFrom readFrom) {
        this.readFrom = readFrom;
        return this;
    }

    public StatefulRedisModulesConnection<String, String> connection() {
        return this.connection((RedisCodec)StringCodec.UTF8);
    }

    public StatefulRedisPubSubConnection<String, String> pubSubConnection() {
        return this.pubSubConnection((RedisCodec)StringCodec.UTF8);
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> pubSubConnection(RedisCodec<K, V> codec) {
        if (this.client instanceof RedisModulesClusterClient) {
            return ((RedisModulesClusterClient)this.client).connectPubSub(codec);
        }
        return ((RedisModulesClient)this.client).connectPubSub(codec);
    }

    public <K, V> Supplier<StatefulRedisModulesConnection<K, V>> connectionSupplier(RedisCodec<K, V> codec) {
        return () -> this.connection(codec);
    }

    public <K, V> StatefulRedisModulesConnection<K, V> connection(RedisCodec<K, V> codec) {
        if (this.client instanceof RedisModulesClusterClient) {
            StatefulRedisModulesClusterConnection connection = ((RedisModulesClusterClient)this.client).connect(codec);
            if (this.readFrom != null) {
                connection.setReadFrom(this.readFrom);
            }
            return connection;
        }
        return ((RedisModulesClient)this.client).connect(codec);
    }
}

