/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.utils;

import io.lettuce.core.SslOptions;
import java.io.File;

public class SslOptionsBuilder {
    private File keystore;
    private char[] keystorePassword;
    private File truststore;
    private char[] truststorePassword;
    private File keyCert;
    private File key;
    private char[] keyPassword;
    private File trustedCerts;

    public SslOptions build() {
        SslOptions.Builder ssl = SslOptions.builder();
        if (this.key != null) {
            ssl.keyManager(this.keyCert, this.key, this.keyPassword);
        }
        if (this.keystore != null) {
            ssl.keystore(this.keystore, this.keystorePassword);
        }
        if (this.truststore != null) {
            ssl.truststore(SslOptions.Resource.from((File)this.truststore), this.truststorePassword);
        }
        if (this.trustedCerts != null) {
            ssl.trustManager(this.trustedCerts);
        }
        return ssl.build();
    }

    public SslOptionsBuilder keystore(File keystore) {
        this.keystore = keystore;
        return this;
    }

    public char[] keystorePassword() {
        return this.keystorePassword;
    }

    public SslOptionsBuilder keystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public File truststore() {
        return this.truststore;
    }

    public SslOptionsBuilder truststore(File truststore) {
        this.truststore = truststore;
        return this;
    }

    public char[] truststorePassword() {
        return this.truststorePassword;
    }

    public SslOptionsBuilder truststorePassword(char[] truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    public File keyCert() {
        return this.keyCert;
    }

    public SslOptionsBuilder keyCert(File keyCert) {
        this.keyCert = keyCert;
        return this;
    }

    public File key() {
        return this.key;
    }

    public SslOptionsBuilder key(File key) {
        this.key = key;
        return this;
    }

    public char[] keyPassword() {
        return this.keyPassword;
    }

    public SslOptionsBuilder keyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public File trustedCerts() {
        return this.trustedCerts;
    }

    public SslOptionsBuilder trustedCerts(File trustedCerts) {
        this.trustedCerts = trustedCerts;
        return this;
    }
}

