/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.utils;

import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslVerifyMode;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceStrings;
import java.lang.reflect.Array;
import java.time.Duration;
import java.util.Arrays;
import lombok.Generated;

public class URIBuilder {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 6379;
    public static final Duration DEFAULT_TIMEOUT_DURATION = RedisURI.DEFAULT_TIMEOUT_DURATION;
    public static final SslVerifyMode DEFAULT_VERIFY_MODE = SslVerifyMode.FULL;
    private RedisURI uri;
    private String host = "127.0.0.1";
    private int port = 6379;
    private String socket;
    private String username;
    private char[] password;
    private Duration timeout = DEFAULT_TIMEOUT_DURATION;
    private int database;
    private String clientName;
    private String libraryName;
    private String libraryVersion;
    private boolean tls;
    private SslVerifyMode verifyMode = DEFAULT_VERIFY_MODE;
    private RedisCredentialsProvider credentialsProvider;

    public RedisURI build() {
        RedisURI.Builder builder = this.redisURIBuilder();
        if (this.credentialsProvider != null) {
            builder.withAuthentication(this.credentialsProvider);
        }
        if (this.password != null && Array.getLength(this.password) > 0) {
            if (LettuceStrings.isNotEmpty((String)this.username)) {
                builder.withAuthentication(this.username, this.password);
            } else {
                builder.withPassword(this.password);
            }
        }
        if (this.database > 0) {
            builder.withDatabase(this.database);
        }
        if (this.tls) {
            builder.withSsl(this.tls);
        }
        builder.withVerifyPeer(this.verifyMode);
        if (this.timeout != null) {
            builder.withTimeout(this.timeout);
        }
        RedisURI redisURI = builder.build();
        if (LettuceStrings.isNotEmpty((String)this.libraryName) && LettuceStrings.isEmpty((String)redisURI.getLibraryName())) {
            redisURI.setLibraryName(this.libraryName);
        }
        if (LettuceStrings.isNotEmpty((String)this.libraryVersion) && LettuceStrings.isEmpty((String)redisURI.getLibraryVersion())) {
            redisURI.setLibraryVersion(this.libraryVersion);
        }
        if (LettuceStrings.isNotEmpty((String)this.clientName) && LettuceStrings.isEmpty((String)redisURI.getClientName())) {
            redisURI.setClientName(this.clientName);
        }
        return redisURI;
    }

    private RedisURI.Builder redisURIBuilder() {
        if (this.uri != null) {
            RedisURI.Builder builder = RedisURI.builder((RedisURI)this.uri);
            if (LettuceStrings.isNotEmpty((String)this.uri.getSentinelMasterId())) {
                builder.withSentinelMasterId(this.uri.getSentinelMasterId());
            }
            this.uri.getSentinels().forEach(arg_0 -> ((RedisURI.Builder)builder).withSentinel(arg_0));
            return builder;
        }
        if (LettuceStrings.isNotEmpty((String)this.socket)) {
            return RedisURI.Builder.socket((String)this.socket);
        }
        return RedisURI.Builder.redis((String)this.host, (int)this.port);
    }

    public URIBuilder uri(String uri) {
        return this.uri(RedisURI.create((String)uri));
    }

    public URIBuilder uri(RedisURI uri) {
        this.uri = uri;
        return this;
    }

    public URIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public URIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public URIBuilder socket(String socket) {
        this.socket = socket;
        return this;
    }

    public URIBuilder username(String username) {
        this.username = username;
        return this;
    }

    public URIBuilder password(String password) {
        LettuceAssert.notNull((Object)password, (String)"Password must not be null");
        return this.password(password.toCharArray());
    }

    public URIBuilder password(char[] password) {
        this.password = password;
        return this;
    }

    public URIBuilder timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public URIBuilder database(int database) {
        this.database = database;
        return this;
    }

    public URIBuilder clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public URIBuilder libraryName(String libraryName) {
        this.libraryName = libraryName;
        return this;
    }

    public URIBuilder libraryVersion(String libraryVersion) {
        this.libraryVersion = libraryVersion;
        return this;
    }

    public URIBuilder tls(boolean tls) {
        this.tls = tls;
        return this;
    }

    public URIBuilder noVerifyPeer() {
        return this.verifyPeer(false);
    }

    public URIBuilder verifyPeer(boolean enable) {
        return this.verifyMode(enable ? SslVerifyMode.FULL : SslVerifyMode.NONE);
    }

    public URIBuilder verifyMode(SslVerifyMode verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public URIBuilder credentialsProvider(RedisCredentialsProvider provider) {
        this.credentialsProvider = provider;
        return this;
    }

    public static URIBuilder of(String uri) {
        return new URIBuilder().uri(uri);
    }

    public static URIBuilder of(RedisURI uri) {
        return new URIBuilder().uri(uri);
    }

    public static URIBuilder of(String host, int port) {
        return new URIBuilder().host(host).port(port);
    }

    @Generated
    public String toString() {
        return "URIBuilder(uri=" + String.valueOf(this.uri) + ", host=" + this.host + ", port=" + this.port + ", socket=" + this.socket + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", timeout=" + String.valueOf(this.timeout) + ", database=" + this.database + ", clientName=" + this.clientName + ", libraryName=" + this.libraryName + ", libraryVersion=" + this.libraryVersion + ", tls=" + this.tls + ", verifyMode=" + String.valueOf(this.verifyMode) + ", credentialsProvider=" + String.valueOf(this.credentialsProvider) + ")";
    }
}

