/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.bloom;

import io.lettuce.core.Value;
import io.lettuce.core.internal.LettuceAssert;
import java.util.Optional;
import java.util.function.Function;

public class LongScoredValue<V>
extends Value<V> {
    private static final long serialVersionUID = 1L;
    private static final LongScoredValue<Object> EMPTY = new LongScoredValue<Object>(0L, null);
    private final long score;

    protected LongScoredValue() {
        super(null);
        this.score = 0L;
    }

    private LongScoredValue(long score, V value) {
        super(value);
        this.score = score;
    }

    public static <T extends V, V> LongScoredValue<V> from(long score, Optional<T> optional) {
        LettuceAssert.notNull(optional, (String)"Optional must not be null");
        if (optional.isPresent()) {
            return new LongScoredValue<T>(score, optional.get());
        }
        return LongScoredValue.empty();
    }

    public static <T extends V, V> LongScoredValue<V> fromNullable(long score, T value) {
        if (value == null) {
            return LongScoredValue.empty();
        }
        return new LongScoredValue<T>(score, value);
    }

    public static <V> LongScoredValue<V> empty() {
        return EMPTY;
    }

    public static <T extends V, V> LongScoredValue<V> just(long score, T value) {
        LettuceAssert.notNull(value, (String)"Value must not be null");
        return new LongScoredValue<T>(score, value);
    }

    public long getScore() {
        return this.score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongScoredValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LongScoredValue that = (LongScoredValue)((Object)o);
        return Long.compare(that.score, this.score) == 0;
    }

    public int hashCode() {
        int result = (int)(this.score ^ this.score >>> 32);
        result = 31 * result + (this.hasValue() ? this.getValue().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.hasValue() ? String.format("LongScoredValue[%f, %s]", this.score, this.getValue()) : String.format("LongScoredValue[%f].empty", this.score);
    }

    public <R> LongScoredValue<R> map(Function<? super V, ? extends R> mapper) {
        LettuceAssert.notNull(mapper, (String)"Mapper function must not be null");
        if (this.hasValue()) {
            return new LongScoredValue<R>(this.score, mapper.apply(this.getValue()));
        }
        return this;
    }

    public LongScoredValue<V> mapScore(Function<? super Number, ? extends Number> mapper) {
        LettuceAssert.notNull(mapper, (String)"Mapper function must not be null");
        if (this.hasValue()) {
            return new LongScoredValue<Object>(mapper.apply((Number)this.score).longValue(), this.getValue());
        }
        return this;
    }
}

