/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.output.ExecutionResults;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExecutionResultsOutput<K, V>
extends CommandOutput<K, V, ExecutionResults> {
    private static final ByteBuffer OK = StandardCharsets.US_ASCII.encode("OK");
    private List<Object> current;
    private boolean initialized;

    public ExecutionResultsOutput(RedisCodec<K, V> codec) {
        super(codec, (Object)new ExecutionResults());
    }

    public void set(ByteBuffer bytes) {
        if (bytes == null && !this.initialized) {
            return;
        }
        if (this.current == null) {
            if (OK.equals(bytes)) {
                ((ExecutionResults)this.output).setOk(true);
            } else {
                ((ExecutionResults)this.output).setErrors(Collections.singletonList(this.decodeString(bytes)));
            }
            return;
        }
        this.current.add(this.codec.decodeValue(bytes));
    }

    public void multi(int count) {
        if (!this.initialized) {
            this.initialized = true;
            return;
        }
        if (((ExecutionResults)this.output).getResults() == null) {
            ArrayList<Object> results = new ArrayList<Object>(count);
            ((ExecutionResults)this.output).setResults(results);
            this.current = results;
            return;
        }
        ((ExecutionResults)this.output).setErrors(new ArrayList<String>(count));
        this.current = new ArrayList<Object>(count);
    }
}

