/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import lombok.Generated;

public class CreateOptions<K, V>
implements RediSearchArgument<K, V> {
    private Optional<DataType> on = Optional.empty();
    private List<K> prefixes = new ArrayList<K>();
    private Optional<V> filter = Optional.empty();
    private Optional<Language> defaultLanguage = Optional.empty();
    private Optional<K> languageField = Optional.empty();
    private OptionalDouble defaultScore = OptionalDouble.empty();
    private Optional<K> scoreField = Optional.empty();
    private Optional<K> payloadField = Optional.empty();
    private boolean maxTextFields;
    private OptionalLong temporary = OptionalLong.empty();
    private boolean noOffsets;
    private boolean noHL;
    private boolean noFields;
    private boolean noFreqs;
    private boolean skipInitialScan;
    private Optional<List<V>> stopWords = Optional.empty();

    public CreateOptions() {
    }

    private CreateOptions(Builder<K, V> builder) {
        this.on = builder.on;
        this.prefixes = builder.prefixes;
        this.filter = builder.filter;
        this.defaultLanguage = builder.defaultLanguage;
        this.languageField = builder.languageField;
        this.defaultScore = builder.defaultScore;
        this.scoreField = builder.scoreField;
        this.payloadField = builder.payloadField;
        this.maxTextFields = builder.maxTextFields;
        this.temporary = builder.temporary;
        this.noOffsets = builder.noOffsets;
        this.noHL = builder.noHL;
        this.noFields = builder.noFields;
        this.noFreqs = builder.noFreqs;
        this.skipInitialScan = builder.skipInitialScan;
        this.stopWords = builder.stopWords;
    }

    public Optional<DataType> getOn() {
        return this.on;
    }

    public void setOn(Optional<DataType> on) {
        this.on = on;
    }

    public Optional<V> getFilter() {
        return this.filter;
    }

    public void setFilter(Optional<V> filter) {
        this.filter = filter;
    }

    public Optional<Language> getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(Optional<Language> defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public Optional<K> getLanguageField() {
        return this.languageField;
    }

    public void setLanguageField(Optional<K> languageField) {
        this.languageField = languageField;
    }

    public OptionalDouble getDefaultScore() {
        return this.defaultScore;
    }

    public void setDefaultScore(OptionalDouble defaultScore) {
        this.defaultScore = defaultScore;
    }

    public Optional<K> getScoreField() {
        return this.scoreField;
    }

    public void setScoreField(Optional<K> scoreField) {
        this.scoreField = scoreField;
    }

    public Optional<K> getPayloadField() {
        return this.payloadField;
    }

    public void setPayloadField(Optional<K> payloadField) {
        this.payloadField = payloadField;
    }

    public boolean isMaxTextFields() {
        return this.maxTextFields;
    }

    public void setMaxTextFields(boolean maxTextFields) {
        this.maxTextFields = maxTextFields;
    }

    public OptionalLong getTemporary() {
        return this.temporary;
    }

    public void setTemporary(OptionalLong temporary) {
        this.temporary = temporary;
    }

    public boolean isNoOffsets() {
        return this.noOffsets;
    }

    public void setNoOffsets(boolean noOffsets) {
        this.noOffsets = noOffsets;
    }

    public boolean isNoHL() {
        return this.noHL;
    }

    public void setNoHL(boolean noHL) {
        this.noHL = noHL;
    }

    public boolean isNoFields() {
        return this.noFields;
    }

    public void setNoFields(boolean noFields) {
        this.noFields = noFields;
    }

    public boolean isNoFreqs() {
        return this.noFreqs;
    }

    public void setNoFreqs(boolean noFreqs) {
        this.noFreqs = noFreqs;
    }

    public boolean isSkipInitialScan() {
        return this.skipInitialScan;
    }

    public void setSkipInitialScan(boolean skipInitialScan) {
        this.skipInitialScan = skipInitialScan;
    }

    public Optional<List<V>> getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(Optional<List<V>> stopWords) {
        this.stopWords = stopWords;
    }

    public List<K> getPrefixes() {
        return this.prefixes;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        this.on.ifPresent(o -> args.add(SearchCommandKeyword.ON).add(o.name()));
        if (!this.prefixes.isEmpty()) {
            args.add(SearchCommandKeyword.PREFIX);
            args.add(this.prefixes.size());
            this.prefixes.forEach(args::addKey);
        }
        this.filter.ifPresent(f -> args.add(SearchCommandKeyword.FILTER).addValue(f));
        this.defaultLanguage.ifPresent(l -> args.add(SearchCommandKeyword.LANGUAGE).add(l.getId()));
        this.languageField.ifPresent(f -> args.add(SearchCommandKeyword.LANGUAGE_FIELD).addKey(f));
        this.defaultScore.ifPresent(s -> args.add(SearchCommandKeyword.SCORE).add(s));
        this.scoreField.ifPresent(f -> args.add(SearchCommandKeyword.SCORE_FIELD).addKey(f));
        this.payloadField.ifPresent(f -> args.add(SearchCommandKeyword.PAYLOAD_FIELD).addKey(f));
        if (this.maxTextFields) {
            args.add(SearchCommandKeyword.MAXTEXTFIELDS);
        }
        this.temporary.ifPresent(t -> args.add(SearchCommandKeyword.TEMPORARY).add(t));
        if (this.noOffsets) {
            args.add(SearchCommandKeyword.NOOFFSETS);
        }
        if (this.noHL) {
            args.add(SearchCommandKeyword.NOHL);
        }
        if (this.noFields) {
            args.add(SearchCommandKeyword.NOFIELDS);
        }
        if (this.noFreqs) {
            args.add(SearchCommandKeyword.NOFREQS);
        }
        if (this.skipInitialScan) {
            args.add(SearchCommandKeyword.SKIPINITIALSCAN);
        }
        this.stopWords.ifPresent(w -> {
            args.add(SearchCommandKeyword.STOPWORDS).add(w.size());
            w.forEach(args::addValue);
        });
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.defaultLanguage, this.defaultScore, this.filter, this.languageField, this.maxTextFields, this.noFields, this.noFreqs, this.noHL, this.noOffsets, this.on, this.payloadField, this.prefixes, this.scoreField, this.skipInitialScan, this.stopWords, this.temporary);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateOptions other = (CreateOptions)obj;
        return Objects.equals(this.defaultLanguage, other.defaultLanguage) && Objects.equals(this.defaultScore, other.defaultScore) && Objects.equals(this.filter, other.filter) && Objects.equals(this.languageField, other.languageField) && this.maxTextFields == other.maxTextFields && this.noFields == other.noFields && this.noFreqs == other.noFreqs && this.noHL == other.noHL && this.noOffsets == other.noOffsets && Objects.equals(this.on, other.on) && Objects.equals(this.payloadField, other.payloadField) && Objects.equals(this.prefixes, other.prefixes) && Objects.equals(this.scoreField, other.scoreField) && this.skipInitialScan == other.skipInitialScan && Objects.equals(this.stopWords, other.stopWords) && Objects.equals(this.temporary, other.temporary);
    }

    @Generated
    public String toString() {
        return "CreateOptions(on=" + String.valueOf(this.getOn()) + ", prefixes=" + String.valueOf(this.getPrefixes()) + ", filter=" + String.valueOf(this.getFilter()) + ", defaultLanguage=" + String.valueOf(this.getDefaultLanguage()) + ", languageField=" + String.valueOf(this.getLanguageField()) + ", defaultScore=" + String.valueOf(this.getDefaultScore()) + ", scoreField=" + String.valueOf(this.getScoreField()) + ", payloadField=" + String.valueOf(this.getPayloadField()) + ", maxTextFields=" + this.isMaxTextFields() + ", temporary=" + String.valueOf(this.getTemporary()) + ", noOffsets=" + this.isNoOffsets() + ", noHL=" + this.isNoHL() + ", noFields=" + this.isNoFields() + ", noFreqs=" + this.isNoFreqs() + ", skipInitialScan=" + this.isSkipInitialScan() + ", stopWords=" + String.valueOf(this.getStopWords()) + ")";
    }

    public static final class Builder<K, V> {
        private Optional<DataType> on = Optional.of(DataType.HASH);
        private List<K> prefixes = new ArrayList<K>();
        private Optional<V> filter = Optional.empty();
        private Optional<Language> defaultLanguage = Optional.empty();
        private Optional<K> languageField = Optional.empty();
        private OptionalDouble defaultScore = OptionalDouble.empty();
        private Optional<K> scoreField = Optional.empty();
        private Optional<K> payloadField = Optional.empty();
        private boolean maxTextFields;
        private OptionalLong temporary = OptionalLong.empty();
        private boolean noOffsets;
        private boolean noHL;
        private boolean noFields;
        private boolean noFreqs;
        private boolean skipInitialScan;
        private Optional<List<V>> stopWords = Optional.empty();

        public Builder<K, V> on(DataType on) {
            this.on = Optional.of(on);
            return this;
        }

        public Builder<K, V> prefix(K prefix) {
            this.prefixes.add(prefix);
            return this;
        }

        public Builder<K, V> prefixes(K ... prefixes) {
            this.prefixes.addAll(Arrays.asList(prefixes));
            return this;
        }

        public Builder<K, V> filter(V filter) {
            this.filter = Optional.of(filter);
            return this;
        }

        public Builder<K, V> defaultLanguage(Language defaultLanguage) {
            this.defaultLanguage = Optional.of(defaultLanguage);
            return this;
        }

        public Builder<K, V> languageField(K languageField) {
            this.languageField = Optional.of(languageField);
            return this;
        }

        public Builder<K, V> defaultScore(double defaultScore) {
            this.defaultScore = OptionalDouble.of(defaultScore);
            return this;
        }

        public Builder<K, V> scoreField(K scoreField) {
            this.scoreField = Optional.of(scoreField);
            return this;
        }

        public Builder<K, V> payloadField(K payloadField) {
            this.payloadField = Optional.of(payloadField);
            return this;
        }

        public Builder<K, V> maxTextFields() {
            return this.maxTextFields(true);
        }

        public Builder<K, V> maxTextFields(boolean maxTextFields) {
            this.maxTextFields = maxTextFields;
            return this;
        }

        public Builder<K, V> temporary(long temporary) {
            this.temporary = OptionalLong.of(temporary);
            return this;
        }

        public Builder<K, V> noOffsets() {
            return this.noOffsets(true);
        }

        public Builder<K, V> noOffsets(boolean noOffsets) {
            this.noOffsets = noOffsets;
            return this;
        }

        public Builder<K, V> noHL() {
            return this.noHL(true);
        }

        public Builder<K, V> noHL(boolean noHL) {
            this.noHL = noHL;
            return this;
        }

        public Builder<K, V> noFields() {
            return this.noFields(true);
        }

        public Builder<K, V> noFields(boolean noFields) {
            this.noFields = noFields;
            return this;
        }

        public Builder<K, V> noFreqs() {
            return this.noFreqs(true);
        }

        public Builder<K, V> noFreqs(boolean noFreqs) {
            this.noFreqs = noFreqs;
            return this;
        }

        public Builder<K, V> skipInitialScan() {
            return this.skipInitialScan(true);
        }

        public Builder<K, V> skipInitialScan(boolean skipInitialScan) {
            this.skipInitialScan = skipInitialScan;
            return this;
        }

        public Builder<K, V> stopWords(V ... stopWords) {
            this.stopWords = Optional.of(Arrays.asList(stopWords));
            return this;
        }

        public CreateOptions<K, V> build() {
            return new CreateOptions(this);
        }
    }

    public static enum DataType {
        HASH,
        JSON;

    }
}

