/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.BaseOptions;
import com.redis.lettucemod.timeseries.DuplicatePolicy;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Optional;

public class BaseCreateOptions<K, V>
extends BaseOptions<K, V> {
    private final TimeSeriesCommandKeyword duplicatePolicyKeyword;
    private Optional<BaseOptions.Encoding> encoding = Optional.empty();
    private Optional<DuplicatePolicy> duplicatePolicy = Optional.empty();

    public BaseCreateOptions(TimeSeriesCommandKeyword duplicatePolicyKeyword) {
        this.duplicatePolicyKeyword = duplicatePolicyKeyword;
    }

    protected BaseCreateOptions(TimeSeriesCommandKeyword duplicatePolicyKeyword, Builder<K, V, ?> builder) {
        super(builder);
        this.duplicatePolicyKeyword = duplicatePolicyKeyword;
        this.encoding = builder.encoding;
        this.duplicatePolicy = builder.policy;
    }

    public Optional<BaseOptions.Encoding> getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Optional<BaseOptions.Encoding> encoding) {
        this.encoding = encoding;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        this.duplicatePolicy.ifPresent(p -> args.add((ProtocolKeyword)this.duplicatePolicyKeyword).add((ProtocolKeyword)p.getKeyword()));
        this.encoding.ifPresent(e -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.ENCODING).add((ProtocolKeyword)e.getKeyword()));
        super.build(args);
    }

    public static class Builder<K, V, B extends Builder<K, V, B>>
    extends BaseOptions.Builder<K, V, B> {
        private Optional<BaseOptions.Encoding> encoding = Optional.empty();
        private Optional<DuplicatePolicy> policy = Optional.empty();

        public B encoding(BaseOptions.Encoding encoding) {
            this.encoding = Optional.of(encoding);
            return (B)this;
        }

        public B policy(DuplicatePolicy policy) {
            this.policy = Optional.of(policy);
            return (B)this;
        }
    }
}

