/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.Timestamp;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;

public class TimeRange
implements CompositeArgument {
    private final Timestamp from;
    private final Timestamp to;

    private TimeRange(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.from.isUnbounded()) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.START);
        } else {
            args.add(this.from.getValue());
        }
        if (this.to.isUnbounded()) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.END);
        } else {
            args.add(this.to.getValue());
        }
    }

    public static Builder from(long timestamp) {
        return TimeRange.builder().from(timestamp);
    }

    public static Builder to(long timestamp) {
        return TimeRange.builder().to(timestamp);
    }

    public static TimeRange unbounded() {
        return TimeRange.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Timestamp from = Timestamp.unbounded();
        private Timestamp to = Timestamp.unbounded();

        public Builder from(long timestamp) {
            this.from = Timestamp.of(timestamp);
            return this;
        }

        public Builder to(long timestamp) {
            this.to = Timestamp.of(timestamp);
            return this;
        }

        public TimeRange build() {
            return new TimeRange(this);
        }
    }
}

