/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.core.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tinet.clink.core.auth.Credentials;
import com.tinet.clink.core.auth.SignatureComposer;
import com.tinet.clink.core.auth.Signer;
import com.tinet.clink.core.response.ResponseModel;
import com.tinet.clink.core.utils.HttpMethodType;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.http.client.utils.URIBuilder;

public abstract class AbstractRequestModel<T extends ResponseModel> {
    private int expires = 600;
    private String path;
    private HttpMethodType httpMethod = HttpMethodType.GET;
    private SignatureComposer composer = null;
    private final Map<String, String> queryParameters = new TreeMap<String, String>();
    protected Map<String, List<File>> fileMap = null;
    protected Object model = null;

    public AbstractRequestModel(String path) {
        this.composer = new SignatureComposer();
        this.path = path;
    }

    public AbstractRequestModel(String path, HttpMethodType httpMethod) {
        this.composer = new SignatureComposer();
        this.path = path;
        this.httpMethod = httpMethod;
    }

    public void signRequest(Signer signer, Credentials credentials, String domain) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.putQueryParameter("AccessKeyId", credentials.getAccessKeyId());
        this.putQueryParameter("Expires", this.expires);
        this.putQueryParameter("Timestamp", sdf.format(new Date()));
        String stringToSign = this.composer.getStringToSign(this.httpMethod.toString(), domain, "/" + this.path + "?", this.queryParameters);
        String signature = signer.signString(stringToSign, credentials);
        this.putQueryParameter("Signature", signature);
    }

    protected void putQueryParameter(String name, Object value) {
        try {
            String encodedKey = URLEncoder.encode(name, "UTF-8");
            String encodedValue = URLEncoder.encode(String.valueOf(value), "UTF-8");
            this.queryParameters.put(encodedKey, encodedValue);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void expires(int expires) {
        this.expires = expires;
    }

    public int expires() {
        return this.expires;
    }

    protected void putBodyParameter(String name, Object value) {
    }

    @JsonIgnore
    public abstract Class<T> getResponseClass();

    @JsonIgnore
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String generateUri() throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        for (String key : this.queryParameters.keySet()) {
            builder.setParameter(key, this.queryParameters.get(key));
        }
        return builder.build().getQuery();
    }

    public HttpMethodType httpMethod() {
        return this.httpMethod;
    }

    @JsonIgnore
    public boolean isMultipartFormData() {
        return false;
    }

    @JsonIgnore
    public Map<String, List<File>> getFileMap() {
        return this.fileMap;
    }

    @JsonIgnore
    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public void setFileMap(Map<String, List<File>> fileMap) {
        this.fileMap = fileMap;
    }
}

