/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.core.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class CommonUtils {
    private static List<Integer> IB_ANSWER = Arrays.asList(1);
    private static List<Integer> IB_NO_ANSWER = Arrays.asList(2);
    private static List<Integer> IB_SYSTEM_ANSWER = Arrays.asList(3);
    private static List<Integer> IB_SYSTEM_NO_ANSWER = Arrays.asList(4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
    private static List<Integer> OB_CUSTOMER_NO_ANSWER = Arrays.asList(31, 32, 40, 50, 51, 20, 21, 25, 26, 27, 61, 62);
    private static List<Integer> OB_AGENT_NO_ANSWER = Arrays.asList(30, 42, 41, 22, 23, 60);
    private static List<Integer> OB_BRIDGED = Arrays.asList(33, 43, 52, 28, 24, 63);

    public static String getStatus(Integer status) {
        String result = "";
        if (!Objects.isNull(status)) {
            switch (status) {
                case 1: {
                    result = "\u5ea7\u5e2d\u63a5\u542c";
                    break;
                }
                case 2: {
                    result = "\u5ea7\u5e2d\u672a\u63a5\u542c";
                    break;
                }
                case 3: {
                    result = "\u7cfb\u7edf\u63a5\u542c";
                    break;
                }
                case 4: {
                    result = "\u7cfb\u7edf\u672a\u63a5-IVR\u914d\u7f6e\u9519\u8bef";
                    break;
                }
                case 5: {
                    result = "\u7cfb\u7edf\u672a\u63a5-\u505c\u673a";
                    break;
                }
                case 6: {
                    result = "\u7cfb\u7edf\u672a\u63a5-\u6b20\u8d39";
                    break;
                }
                case 7: {
                    result = "\u7cfb\u7edf\u672a\u63a5-\u9ed1\u540d\u5355";
                    break;
                }
                case 8: {
                    result = "\u7cfb\u7edf\u672a\u63a5-\u672a\u6ce8\u518c";
                    break;
                }
                case 9: {
                    result = "\u7cfb\u7edf\u672a\u63a5-\u5f69\u94c3";
                    break;
                }
                case 10: {
                    result = "\u7f51\u4e0a400\u672a\u63a5\u53d7";
                    break;
                }
                case 11: {
                    result = "\u547c\u53eb\u8d85\u51fa\u8425\u5e10\u4e2d\u8bbe\u7f6e\u7684\u6700\u5927\u9650\u5236";
                    break;
                }
                case 12: {
                    result = "\u5ba2\u6237\u547c\u5165\u7cfb\u7edf\u540e\u5728\u7cfb\u7edf\u672a\u5e94\u7b54\u524d\u6302\u673a";
                    break;
                }
                case 13: {
                    result = "\u5176\u4ed6\u9519\u8bef";
                    break;
                }
                case 20: {
                    result = "webcall\u5ba2\u6237TTS\u5931\u8d25";
                    break;
                }
                case 22: {
                    result = "webcall\u5ba2\u6237\u63a5\u542c";
                    break;
                }
                case 61: {
                    result = "\u5185\u90e8\u547c\u53eb\u5ea7\u5e2d\u63a5\u542c";
                    break;
                }
                case 21: 
                case 25: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 40: 
                case 50: 
                case 51: 
                case 62: {
                    result = "\u5ba2\u6237\u672a\u63a5\u542c";
                    break;
                }
                case 23: 
                case 30: 
                case 41: 
                case 42: 
                case 60: {
                    result = "\u5ea7\u5e2d\u672a\u63a5\u542c";
                    break;
                }
                case 24: 
                case 28: 
                case 33: 
                case 43: 
                case 52: 
                case 63: {
                    result = "\u53cc\u65b9\u63a5\u542c";
                    break;
                }
            }
        }
        return result;
    }

    public static String conversionStatus(Integer status) {
        String result = "";
        if (!Objects.isNull(status)) {
            if (IB_ANSWER.contains(status)) {
                result = "\u4eba\u5de5\u63a5\u542c";
            }
            if (IB_NO_ANSWER.contains(status)) {
                result = "\u4eba\u5de5\u672a\u63a5\u542c";
            }
            if (IB_SYSTEM_ANSWER.contains(status)) {
                result = "\u7cfb\u7edf\u5e94\u7b54";
            }
            if (IB_SYSTEM_NO_ANSWER.contains(status)) {
                result = "\u7cfb\u7edf\u672a\u5e94\u7b54";
            }
            if (OB_CUSTOMER_NO_ANSWER.contains(status)) {
                result = "\u5ba2\u6237\u672a\u63a5\u542c";
            }
            if (OB_AGENT_NO_ANSWER.contains(status)) {
                result = "\u5ea7\u5e2d\u672a\u63a5\u542c";
            }
            if (OB_BRIDGED.contains(status)) {
                result = "\u53cc\u65b9\u63a5\u542c";
            }
        }
        return result;
    }

    public static String getCallType(Integer type) {
        String result = "";
        if (Objects.nonNull(type)) {
            switch (type) {
                case 1: {
                    result = "\u547c\u5165";
                    break;
                }
                case 2: {
                    result = "webCall";
                    break;
                }
                case 3: {
                    result = "\u70b9\u51fb\u5916\u547c";
                    break;
                }
                case 4: {
                    result = "\u9884\u89c8\u5916\u547c";
                    break;
                }
                case 5: {
                    result = "\u9884\u6d4b\u5916\u547c";
                    break;
                }
                case 6: {
                    result = "\u76f4\u63a5\u5916\u547c";
                    break;
                }
                case 7: {
                    result = "\u81ea\u52a9\u5f55\u97f3";
                    break;
                }
                case 8: {
                    result = "\u53d1\u9001\u4f20\u771f";
                    break;
                }
                case 9: {
                    result = "\u5185\u90e8\u547c\u53eb";
                    break;
                }
                case 10: {
                    result = "\u9884\u7ea6\u56de\u547c";
                    break;
                }
                case 101: 
                case 201: {
                    result = "\u547c\u8f6c\u5ea7\u5e2d";
                    break;
                }
                case 102: {
                    result = "\u8f6c\u79fb";
                    break;
                }
                case 103: {
                    result = "\u54a8\u8be2";
                    break;
                }
                case 104: {
                    result = "\u4e09\u65b9";
                    break;
                }
                case 105: {
                    result = "\u76d1\u542c";
                    break;
                }
                case 106: {
                    result = "\u8033\u8bed";
                    break;
                }
                case 107: {
                    result = "\u5f3a\u63d2";
                    break;
                }
                case 108: {
                    result = "\u62a2\u7ebf";
                    break;
                }
                case 202: {
                    result = "\u8f6c\u79fb";
                    break;
                }
                case 203: {
                    result = "\u54a8\u8be2";
                    break;
                }
                case 204: {
                    result = "\u4e09\u65b9";
                    break;
                }
                case 205: {
                    result = "\u76d1\u542c";
                    break;
                }
                case 206: {
                    result = "\u8033\u8bed";
                    break;
                }
                case 207: {
                    result = "\u5f3a\u63d2";
                    break;
                }
                case 208: {
                    result = "\u547c\u8f6c\u5ba2\u6237";
                    break;
                }
                case 210: {
                    result = "\u547c\u8f6c\u5206\u673a";
                    break;
                }
                case 109: 
                case 209: {
                    result = "\u547c\u8f6c\u7535\u8bdd";
                    break;
                }
            }
        }
        return result;
    }

    public static String getMark(Integer mark) {
        String result = "";
        if (Objects.nonNull(mark)) {
            switch (mark) {
                case 1: {
                    result = "\u7559\u8a00";
                    break;
                }
                case 2: {
                    result = "\u8f6c\u79fb";
                    break;
                }
                case 3: {
                    result = "\u54a8\u8be2";
                    break;
                }
                case 4: {
                    result = "\u4e09\u65b9";
                    break;
                }
                case 5: {
                    result = "\u4f20\u771f\u63a5\u6536";
                    break;
                }
                case 6: {
                    result = "\u4f1a\u8bae";
                    break;
                }
                case 7: {
                    result = "\u4ea4\u4e92";
                    break;
                }
                case 8: {
                    result = "IVR\u4e2d\u653e\u5f03";
                    break;
                }
                case 9: {
                    result = "\u5df2\u8fdb\u5165IVR";
                    break;
                }
                case 10: {
                    result = "\u672a\u8fdb\u5165IVR";
                    break;
                }
                case 11: {
                    result = "\u961f\u5217\u4e2d\u653e\u5f03";
                    break;
                }
                case 12: {
                    result = "\u961f\u5217\u4e2d\u6ea2\u51fa";
                    break;
                }
            }
        }
        return result;
    }

    public static String getPauseType(Integer pauseType) {
        String result = "";
        if (Objects.nonNull(pauseType)) {
            switch (pauseType) {
                case 1: {
                    result = "\u666e\u901a";
                    break;
                }
                case 2: {
                    result = "\u4f11\u606f";
                    break;
                }
                case 3: {
                    result = "IM";
                    break;
                }
                case 4: {
                    result = "\u5f3a\u5236";
                    break;
                }
            }
        }
        return result;
    }

    public static String getSipCause(Integer sip) {
        return "";
    }

    public static String getEndReason(Integer reason) {
        String str = "";
        if (!Objects.isNull(reason)) {
            switch (reason) {
                case 1000: {
                    str = "\u4e3b\u901a\u9053\u6302\u673a";
                    break;
                }
                case 1001: {
                    str = "\u975e\u4e3b\u901a\u9053\u6302\u673a";
                    break;
                }
                case 1002: {
                    str = "\u88ab\u5f3a\u62c6";
                    break;
                }
            }
        }
        return str;
    }

    public static String getLoginStatus(Integer loginStatus) {
        String str = "";
        if (!Objects.isNull(loginStatus)) {
            switch (loginStatus) {
                case 0: {
                    str = "\u79bb\u7ebf";
                    break;
                }
                case 1: {
                    str = "\u5728\u7ebf\u7a7a\u95f2";
                    break;
                }
                case 2: {
                    str = "\u5728\u7ebf\u7f6e\u5fd9";
                    break;
                }
                case 3: {
                    str = "\u5728\u7ebf\u6574\u7406";
                    break;
                }
            }
        }
        return str;
    }

    public static String getDeviceStatus(Integer deviceStatus) {
        String str = "";
        if (!Objects.isNull(deviceStatus)) {
            switch (deviceStatus) {
                case 0: {
                    str = "\u7a7a\u95f2";
                    break;
                }
                case 1: {
                    str = "\u9501\u5b9a\uff0c\u9501\u5b9a\u5c06\u8981\u4f7f\u7528\u7684\u8bbe\u5907";
                    break;
                }
                case 2: {
                    str = "\u8bf7\u6c42\uff0c\u5c1d\u8bd5\u547c\u53eb\u8bbe\u5907";
                    break;
                }
                case 3: {
                    str = "\u54cd\u94c3\uff0c\u8bbe\u5907\u6b63\u5728\u54cd\u94c3";
                    break;
                }
                case 4: {
                    str = "\u4f7f\u7528\u4e2d\uff0c\u8bbe\u5907\u6b63\u5728\u901a\u8bdd\u4e2d";
                    break;
                }
                case 9: {
                    str = "\u79bb\u7ebf";
                    break;
                }
            }
        }
        return str;
    }
}

