/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.livechat.request;

import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.livechat.PathEnum;
import com.tinet.clink.livechat.response.ChatClientEffortResponse;
import com.tinet.clink.ticket.request.stat.AbstractStatRequest;
import java.util.List;
import java.util.stream.Collectors;

public class ChatClientEffortRequest
extends AbstractStatRequest<ChatClientEffortResponse> {
    private String startTime;
    private String endTime;
    private boolean sortAsc;
    private List<String> cnos;
    private List<Integer> appType;
    private Integer limit;
    private Integer offset;

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
        if (startTime != null) {
            this.putQueryParameter("startTime", startTime);
        }
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
        if (endTime != null) {
            this.putQueryParameter("endTime", endTime);
        }
    }

    public Boolean getSortAsc() {
        return this.sortAsc;
    }

    public void setSortAsc(Boolean sortAsc) {
        this.sortAsc = sortAsc;
        if (sortAsc != null) {
            this.putQueryParameter("sortAsc", sortAsc);
        }
    }

    public List<String> getCnos() {
        return this.cnos;
    }

    public void setCnos(List<String> cnos) {
        this.cnos = cnos;
        if (cnos != null && cnos.size() != 0) {
            this.putQueryParameter("cnos", ChatClientEffortRequest.convertStringListToString(cnos));
        }
    }

    public List<Integer> getAppType() {
        return this.appType;
    }

    public void setAppType(List<Integer> appType) {
        this.appType = appType;
        if (appType != null && appType.size() != 0) {
            this.putQueryParameter("appType", ChatClientEffortRequest.convertIntegerListToString(appType));
        }
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
        if (limit != null) {
            this.putQueryParameter("limit", limit);
        }
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
        if (offset != null) {
            this.putQueryParameter("offset", offset);
        }
    }

    public ChatClientEffortRequest() {
        super(PathEnum.StatChatClientEffort.value(), HttpMethodType.POST);
    }

    @Override
    public Class<ChatClientEffortResponse> getResponseClass() {
        return ChatClientEffortResponse.class;
    }

    private static String convertStringListToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().collect(Collectors.joining(","));
    }

    private static String convertIntegerListToString(List<Integer> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

