/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.util;

import com.xxl.job.core.context.XxlJobHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ScriptUtil {
    public static void markScriptFile(String scriptFileName, String content) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(scriptFileName);
            fileOutputStream.write(content.getBytes("UTF-8"));
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execToFile(String command, String scriptFile, String logFile, String ... params) throws IOException {
        FileOutputStream fileOutputStream = null;
        Thread inputThread = null;
        Thread errThread = null;
        try {
            fileOutputStream = new FileOutputStream(logFile, true);
            ArrayList<String> cmdarray = new ArrayList<String>();
            cmdarray.add(command);
            cmdarray.add(scriptFile);
            if (params != null && params.length > 0) {
                for (String param : params) {
                    cmdarray.add(param);
                }
            }
            String[] cmdarrayFinal = cmdarray.toArray(new String[cmdarray.size()]);
            final Process process = Runtime.getRuntime().exec(cmdarrayFinal);
            final FileOutputStream finalFileOutputStream = fileOutputStream;
            inputThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScriptUtil.copy(process.getInputStream(), finalFileOutputStream, new byte[1024]);
                    }
                    catch (IOException e) {
                        XxlJobHelper.log(e);
                    }
                }
            });
            errThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScriptUtil.copy(process.getErrorStream(), finalFileOutputStream, new byte[1024]);
                    }
                    catch (IOException e) {
                        XxlJobHelper.log(e);
                    }
                }
            });
            inputThread.start();
            errThread.start();
            int exitValue = process.waitFor();
            inputThread.join();
            errThread.join();
            int n = exitValue;
            return n;
        }
        catch (Exception e) {
            XxlJobHelper.log(e);
            int n = -1;
            return n;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    XxlJobHelper.log(e);
                }
            }
            if (inputThread != null && inputThread.isAlive()) {
                inputThread.interrupt();
            }
            if (errThread != null && errThread.isAlive()) {
                errThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        try {
            int res;
            long total = 0L;
            while ((res = inputStream.read(buffer)) != -1) {
                if (res <= 0) continue;
                total += (long)res;
                if (outputStream == null) continue;
                outputStream.write(buffer, 0, res);
            }
            outputStream.flush();
            inputStream.close();
            inputStream = null;
            long l = total;
            return l;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

