/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.List;

public class ContainsFunction
extends BaseFunction {
    public ContainsFunction() {
        super(ArgumentConstraints.typeOf(JmesPathType.ARRAY, JmesPathType.STRING), ArgumentConstraints.anyValue());
    }

    @Override
    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        T haystack = arguments.get(0).value();
        T needle = arguments.get(1).value();
        JmesPathType haystackType = runtime.typeOf(haystack);
        if (haystackType == JmesPathType.ARRAY) {
            return runtime.createBoolean(runtime.toList(haystack).contains(needle));
        }
        return runtime.createBoolean(runtime.toString(haystack).indexOf(runtime.toString(needle)) >= 0);
    }
}

