/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.node.Node;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class CreateObjectNode<T>
extends Node<T> {
    private final List<Entry<T>> entries;

    public CreateObjectNode(Adapter<T> runtime, List<Entry<T>> entries) {
        super(runtime);
        this.entries = entries;
    }

    @Override
    public T search(T input) {
        if (this.runtime.typeOf(input) == JmesPathType.NULL) {
            return input;
        }
        LinkedHashMap object = new LinkedHashMap();
        for (Entry<T> entry : this.entries) {
            object.put(this.runtime.createString(entry.key()), entry.value().search(input));
        }
        return (T)this.runtime.createObject(object);
    }

    @Override
    protected String internalToString() {
        StringBuilder str = new StringBuilder("{");
        Iterator<Entry<T>> entryIterator = this.entries.iterator();
        while (entryIterator.hasNext()) {
            Entry<T> entry = entryIterator.next();
            str.append(entry.key()).append('=').append(entry.value());
            if (!entryIterator.hasNext()) continue;
            str.append(", ");
        }
        str.append('}');
        return str.toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        CreateObjectNode other = (CreateObjectNode)o;
        return this.entries.equals(other.entries);
    }

    @Override
    protected int internalHashCode() {
        int h = 1;
        for (Entry<T> entry : this.entries) {
            h = h * 31 + entry.hashCode();
        }
        return h;
    }

    public static class Entry<U> {
        private final String key;
        private final Expression<U> value;

        public Entry(String key, Expression<U> value) {
            this.key = key;
            this.value = value;
        }

        protected String key() {
            return this.key;
        }

        protected Expression<U> value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            return this.key().equals(other.key()) && this.value().equals(other.value());
        }

        public int hashCode() {
            int h = 1;
            h = h * 31 + this.key.hashCode();
            h = h * 31 + this.value.hashCode();
            return h;
        }
    }
}

