/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.End$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.GroupMessage;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LeakData;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserMessage;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\b\u0010\u0001iA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!9q\u0007\u0001b\u0001\n\u0013A\u0004BB!\u0001A\u0003%\u0011\bC\u0003C\u0001\u0011\u00051\tC\u0003J\u0001\u0011\u0005#\nC\u0003T\u0001\u0011%A\u000bC\u0003\\\u0001\u0011%A\fC\u0003d\u0001\u0011%A\rC\u0003l\u0001\u0011\u0005C\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002\u0006\u0001!\t%a\u0002\u0003-1+\u0017m\u001b*fa>\u0014H/\u001a:ECR\fwK]5uKJT!\u0001E\t\u0002\r]\u0014\u0018\u000e^3s\u0015\t\u00112#A\u0003ti\u0006$8O\u0003\u0002\u0015+\u0005!1m\u001c:f\u0015\t1r#A\u0004hCRd\u0017N\\4\u000b\u0003a\t!![8\u0004\u0001M\u0011\u0001a\u0007\t\u00049uyR\"A\b\n\u0005yy!A\u0003#bi\u0006<&/\u001b;feB\u0011A\u0004I\u0005\u0003C=\u0011\u0001\u0002T3bW\u0012\u000bG/Y\u0001\u0006G2|7m\u001b\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA!\u001e;jY*\u0011\u0001&F\u0001\bG>lWn\u001c8t\u0013\tQSEA\u0003DY>\u001c7.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003[Aj\u0011A\f\u0006\u0003_M\taaY8oM&<\u0017BA\u0019/\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"2\u0001N\u001b7!\ta\u0002\u0001C\u0003#\u0007\u0001\u00071\u0005C\u0003,\u0007\u0001\u0007A&\u0001\bgYV\u001c\b\u000eV5nKJt\u0015-\\3\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\t1\fgn\u001a\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0004TiJLgnZ\u0001\u0010M2,8\u000f\u001b+j[\u0016\u0014h*Y7fA\u00051qN\\%oSR$\"a\b#\t\u000b\u00153\u0001\u0019\u0001$\u0002\t%t\u0017\u000e\u001e\t\u00039\u001dK!\u0001S\b\u0003\t%s\u0017\u000e^\u0001\b_:4E.^:i)\tY\u0015\u000b\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0003V]&$\b\"\u0002*\b\u0001\u0004y\u0012\u0001\u00023bi\u0006\fQb\u001c8Vg\u0016\u0014X*Z:tC\u001e,GcA&V5\")a\u000b\u0003a\u0001/\u0006!Qo]3s!\ta\u0002,\u0003\u0002Z\u001f\tYQk]3s\u001b\u0016\u001c8/Y4f\u0011\u0015\u0011\u0006\u00021\u0001 \u00039ygn\u0012:pkBlUm]:bO\u0016$2aS/c\u0011\u0015q\u0016\u00021\u0001`\u0003\u00159'o\\;q!\ta\u0002-\u0003\u0002b\u001f\taqI]8va6+7o]1hK\")!+\u0003a\u0001?\u0005\trN\u001c*fgB|gn]3NKN\u001c\u0018mZ3\u0015\u0007-+'\u000eC\u0003g\u0015\u0001\u0007q-\u0001\u0005sKN\u0004xN\\:f!\ta\u0002.\u0003\u0002j\u001f\ty!+Z:q_:\u001cX-T3tg\u0006<W\rC\u0003S\u0015\u0001\u0007q$A\u0005p]6+7o]1hKR\u00191*\u001c:\t\u000b9\\\u0001\u0019A8\u0002\u000f5,7o]1hKB\u0011A\u0004]\u0005\u0003c>\u0011\u0001\u0003T8bI\u00163XM\u001c;NKN\u001c\u0018mZ3\t\u000bI[\u0001\u0019A\u0010\u0002\u000f=t7I]1tQR!1*^A\u0002\u0011\u00151H\u00021\u0001x\u0003\u0015\u0019\u0017-^:f!\tAxP\u0004\u0002z{B\u0011!0T\u0007\u0002w*\u0011A0G\u0001\u0007yI|w\u000e\u001e \n\u0005yl\u0015A\u0002)sK\u0012,g-C\u0002A\u0003\u0003Q!A`'\t\u000bIc\u0001\u0019A\u0010\u0002\r=t7\u000b^8q)\rY\u0015\u0011\u0002\u0005\u0006%6\u0001\ra\b")
public class LeakReporterDataWriter
extends DataWriter<LeakData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    @Override
    public LeakData onInit(Init init) {
        FiniteDuration noActivityTimeout = this.configuration.data().leak().noActivityTimeout();
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, noActivityTimeout, true);
        return new LeakData(noActivityTimeout, this.clock.nowMillis(), (Map<Object, DataWriterMessage>)Map$.MODULE$.empty());
    }

    @Override
    public void onFlush(LeakData data) {
        block0: {
            long timeSinceLastTouch = (this.clock.nowMillis() - data.lastTouch()) / 1000L;
            if (timeSinceLastTouch <= data.noActivityTimeout().toSeconds() || !data.events().nonEmpty()) break block0;
            System.err.println(new StringBuilder(96).append("Gatling had no activity during last ").append(data.noActivityTimeout()).append(". It could be a virtual user leak, here's their last events:").toString());
            data.events().values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                System.err.println(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void onUserMessage(UserMessage user, LeakData data) {
        data.lastTouch_$eq(this.clock.nowMillis());
        MessageEvent messageEvent = user.event();
        if (Start$.MODULE$.equals(messageEvent)) {
            data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)user.session().userId())), (Object)user));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (End$.MODULE$.equals(messageEvent)) {
            data.events().$minus$eq((Object)BoxesRunTime.boxToLong((long)user.session().userId()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)messageEvent);
        }
    }

    private void onGroupMessage(GroupMessage group, LeakData data) {
        data.lastTouch_$eq(this.clock.nowMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)group.userId())), (Object)group));
    }

    private void onResponseMessage(ResponseMessage response, LeakData data) {
        data.lastTouch_$eq(this.clock.nowMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)response.userId())), (Object)response));
    }

    @Override
    public void onMessage(LoadEventMessage message, LeakData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof GroupMessage) {
            GroupMessage groupMessage = (GroupMessage)loadEventMessage;
            this.onGroupMessage(groupMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)loadEventMessage);
        }
    }

    @Override
    public void onCrash(String cause, LeakData data) {
    }

    @Override
    public void onStop(LeakData data) {
        this.cancelTimer(this.flushTimerName());
    }

    public LeakReporterDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

