/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.impl.Http2Content;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;

public class ChunkedInboundHttp2ToHttpAdapter
extends Http2EventAdapter {
    private final boolean propagateSettings;
    private final Http2Connection connection;
    private final boolean validateHttpHeaders;
    private final Promise<Channel> whenHttp2Handshake;

    ChunkedInboundHttp2ToHttpAdapter(Http2Connection http2Connection, boolean bl, boolean bl2, Promise<Channel> promise) {
        ObjectUtil.checkNotNull((Object)http2Connection, (String)"connection");
        this.connection = http2Connection;
        this.validateHttpHeaders = bl;
        this.propagateSettings = bl2;
        this.whenHttp2Handshake = promise;
    }

    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) throws Http2Exception {
        Http2Stream http2Stream = this.connection.stream(n);
        if (http2Stream == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)("Data Frame received for unknown stream id " + n), (Object[])new Object[0]);
        }
        int n3 = byteBuf.readableBytes();
        DefaultLastHttpContent defaultLastHttpContent = bl ? new DefaultLastHttpContent(byteBuf) : new DefaultHttpContent(byteBuf);
        channelHandlerContext.fireChannelRead((Object)new Http2Content((HttpContent)defaultLastHttpContent, n));
        return n3 + n2;
    }

    private void convertAndFire(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, boolean bl) throws Http2Exception {
        HttpResponse httpResponse = HttpConversionUtil.toHttpResponse((int)n, (Http2Headers)http2Headers, (boolean)this.validateHttpHeaders);
        channelHandlerContext.fireChannelRead((Object)httpResponse);
        if (bl) {
            channelHandlerContext.fireChannelRead((Object)new Http2Content((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT, n));
        }
    }

    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) throws Http2Exception {
        this.convertAndFire(channelHandlerContext, n, http2Headers, bl);
    }

    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) throws Http2Exception {
        this.onHeadersRead(channelHandlerContext, n, http2Headers, n3, bl2);
    }

    public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
        channelHandlerContext.fireExceptionCaught((Throwable)Http2Exception.streamError((int)n, (Http2Error)Http2Error.valueOf((long)l), (String)"HTTP/2 to HTTP layer caught stream reset", (Object[])new Object[0]));
    }

    public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) throws Http2Exception {
        if (this.connection.stream(n2) != null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Push Promise Frame received for pre-existing stream id %d", (Object[])new Object[]{n2});
        }
        if (http2Headers.status() == null) {
            http2Headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        }
        this.convertAndFire(channelHandlerContext, n, http2Headers, true);
    }

    public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        if (!this.whenHttp2Handshake.isDone()) {
            this.whenHttp2Handshake.setSuccess((Object)channelHandlerContext.channel());
        }
        if (this.propagateSettings) {
            channelHandlerContext.fireChannelRead((Object)http2Settings);
        }
    }
}

