/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.sse.Closed$;
import io.gatling.http.action.sse.Connected$;
import io.gatling.http.action.sse.Connecting$;
import io.gatling.http.action.sse.SseException;
import io.gatling.http.action.sse.SseState;
import io.gatling.http.action.sse.fsm.EventStreamDispatcher;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseReceived;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.action.sse.fsm.SseStreamClosed;
import io.gatling.http.action.sse.fsm.SseStreamConnected;
import io.gatling.http.action.sse.fsm.SseStreamCrashed;
import io.gatling.http.action.sse.fsm.SseStreamDecoder;
import io.gatling.http.client.HttpListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001\u0002\u000b\u0016\u0001\u0001B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"AA\u000b\u0001B\u0001B\u0003%Q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0004e\u0001\u0001\u0007I\u0011B3\t\u000f%\u0004\u0001\u0019!C\u0005U\"11\u000f\u0001Q!\n\u0019Dq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\nu\u0002\u0001\r\u00111A\u0005\nmD1\"a\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n!Q\u0011Q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002?\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!! \u0001\t\u0003\ny\bC\u0004\u0002\u0002\u0002!\t%a!\u0003\u0017M\u001bX\rT5ti\u0016tWM\u001d\u0006\u0003-]\t1a]:f\u0015\tA\u0012$\u0001\u0004bGRLwN\u001c\u0006\u00035m\tA\u0001\u001b;ua*\u0011A$H\u0001\bO\u0006$H.\u001b8h\u0015\u0005q\u0012AA5p\u0007\u0001\u0019b\u0001A\u0011*_UB\u0004C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005)jS\"A\u0016\u000b\u00051J\u0012AB2mS\u0016tG/\u0003\u0002/W\ta\u0001\n\u001e;q\u0019&\u001cH/\u001a8feB\u0011\u0001gM\u0007\u0002c)\u0011!'F\u0001\u0004MNl\u0017B\u0001\u001b2\u0005%\u00196/Z*ue\u0016\fW\u000e\u0005\u00021m%\u0011q'\r\u0002\u0016\u000bZ,g\u000e^*ue\u0016\fW\u000eR5ta\u0006$8\r[3s!\tI\u0004)D\u0001;\u0015\tYD(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002>}\u0005AA/\u001f9fg\u00064WMC\u0001@\u0003\r\u0019w.\\\u0005\u0003\u0003j\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017\u0001C:tK\u0006\u001bGo\u001c:\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015!B1di>\u0014(\"\u0001%\u0002\t\u0005\\7.Y\u0005\u0003\u0015\u0016\u0013\u0001\"Q2u_J\u0014VMZ\u0001\fgR\fGo]#oO&tW\r\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)1\u000f^1ug*\u0011\u0011kG\u0001\u0005G>\u0014X-\u0003\u0002T\u001d\nY1\u000b^1ug\u0016sw-\u001b8f\u0003\u0015\u0019Gn\\2l!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0003vi&d'B\u0001.\u001c\u0003\u001d\u0019w.\\7p]NL!\u0001X,\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\u0011y\u0016MY2\u0011\u0005\u0001\u0004Q\"A\u000b\t\u000b\t#\u0001\u0019A\"\t\u000b-#\u0001\u0019\u0001'\t\u000bQ#\u0001\u0019A+\u0002\u000bM$\u0018\r^3\u0016\u0003\u0019\u0004\"\u0001Y4\n\u0005!,\"\u0001C*tKN#\u0018\r^3\u0002\u0013M$\u0018\r^3`I\u0015\fHCA6r!\taw.D\u0001n\u0015\u0005q\u0017!B:dC2\f\u0017B\u00019n\u0005\u0011)f.\u001b;\t\u000fI4\u0011\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\u0002\rM$\u0018\r^3!\u0003\u001d!WmY8eKJ,\u0012A\u001e\t\u0003a]L!\u0001_\u0019\u0003!M\u001bXm\u0015;sK\u0006lG)Z2pI\u0016\u0014\u0018\u0001\u00033fG>$WM\u001d\u0011\u0002\u000f\rD\u0017M\u001c8fYV\tA\u0010E\u0002~\u0003\u0007i\u0011A \u0006\u0003u~T1!!\u0001\u001e\u0003\u0015qW\r\u001e;z\u0013\r\t)A \u0002\b\u0007\"\fgN\\3m\u0003-\u0019\u0007.\u00198oK2|F%Z9\u0015\u0007-\fY\u0001C\u0004s\u0017\u0005\u0005\t\u0019\u0001?\u0002\u0011\rD\u0017M\u001c8fY\u0002\nqa\u001c8Xe&$X\rF\u0002l\u0003'AQA_\u0007A\u0002q\fab\u001c8IiR\u0004(+Z:q_:\u001cX\rF\u0003l\u00033\ty\u0003C\u0004\u0002\u001c9\u0001\r!!\b\u0002\rM$\u0018\r^;t!\u0011\ty\"a\u000b\u000e\u0005\u0005\u0005\"b\u0001\u000e\u0002$)!\u0011QEA\u0014\u0003\u0015\u0019w\u000eZ3d\u0015\r\tIc`\u0001\bQ\u0006tG\r\\3s\u0013\u0011\ti#!\t\u0003%!#H\u000f\u001d*fgB|gn]3Ti\u0006$Xo\u001d\u0005\b\u0003cq\u0001\u0019AA\u001a\u0003\u001dAW-\u00193feN\u0004B!a\b\u00026%!\u0011qGA\u0011\u0005-AE\u000f\u001e9IK\u0006$WM]:\u0002/=t\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tK\n{G-_\"ik:\\G#B6\u0002>\u00055\u0003bBA \u001f\u0001\u0007\u0011\u0011I\u0001\u0006G\",hn\u001b\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI@\u0002\r\t,hMZ3s\u0013\u0011\tY%!\u0012\u0003\u000f\tKH/\u001a\"vM\"9\u0011qJ\bA\u0002\u0005E\u0013\u0001\u00027bgR\u00042\u0001\\A*\u0013\r\t)&\u001c\u0002\b\u0005>|G.Z1o\u0003-yg\u000e\u00165s_^\f'\r\\3\u0015\u0007-\fY\u0006C\u0004\u0002^A\u0001\r!a\u0018\u0002\u0013QD'o\\<bE2,\u0007\u0003BA1\u0003crA!a\u0019\u0002n9!\u0011QMA6\u001b\t\t9GC\u0002\u0002j}\ta\u0001\u0010:p_Rt\u0014\"\u00018\n\u0007\u0005=T.A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0014Q\u000f\u0002\n)\"\u0014xn^1cY\u0016T1!a\u001cn\u0003=\u0019XM\u001c3P]RC'o\\<bE2,GcA6\u0002|!9\u0011QL\tA\u0002\u0005}\u0013!B2m_N,G#A6\u0002'\u0011L7\u000f]1uG\",e/\u001a8u'R\u0014X-Y7\u0015\u0007-\f)\t\u0003\u0004\u0017'\u0001\u0007\u0011q\u0011\t\u0004a\u0005%\u0015bAAFc\ty1+\u001a:wKJ\u001cVM\u001c;Fm\u0016tG\u000f")
public class SseListener
implements HttpListener,
SseStream,
EventStreamDispatcher,
StrictLogging {
    private final ActorRef sseActor;
    private final Clock clock;
    private SseState state;
    private final SseStreamDecoder decoder;
    private Channel channel;
    private final Logger logger;

    public void onSend() {
        super.onSend();
    }

    public void onTcpConnectAttempt(InetSocketAddress x$1) {
        super.onTcpConnectAttempt(x$1);
    }

    public void onTcpConnectSuccess(InetSocketAddress x$1) {
        super.onTcpConnectSuccess(x$1);
    }

    public void onTcpConnectFailure(InetSocketAddress x$1, Throwable x$2) {
        super.onTcpConnectFailure(x$1, x$2);
    }

    public void onTlsHandshakeAttempt() {
        super.onTlsHandshakeAttempt();
    }

    public void onTlsHandshakeSuccess() {
        super.onTlsHandshakeSuccess();
    }

    public void onTlsHandshakeFailure(Throwable x$1) {
        super.onTlsHandshakeFailure(x$1);
    }

    public void onProtocolAwareness(boolean x$1) {
        super.onProtocolAwareness(x$1);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SseState state() {
        return this.state;
    }

    private void state_$eq(SseState x$1) {
        this.state = x$1;
    }

    private SseStreamDecoder decoder() {
        return this.decoder;
    }

    private Channel channel() {
        return this.channel;
    }

    private void channel_$eq(Channel x$1) {
        this.channel = x$1;
    }

    public void onWrite(Channel channel) {
        this.channel_$eq(channel);
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Status {} received for SSE", new Object[]{BoxesRunTime.boxToInteger((int)status.code())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null) {
            SseException ex = new SseException(status.code());
            this.onThrowable(ex);
            throw ex;
        }
        this.state_$eq(Connected$.MODULE$);
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.sseActor);
        SseStreamConnected x$1 = new SseStreamConnected(this, this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        block1: {
            SseState sseState = this.state();
            Closed$ closed$ = Closed$.MODULE$;
            if (!(sseState == null ? closed$ != null : !sseState.equals(closed$))) break block1;
            Seq<ServerSentEvent> events = this.decoder().decodeStream(chunk);
            events.foreach((Function1 & Serializable & scala.Serializable)sse -> {
                this.dispatchEventStream(sse);
                return BoxedUnit.UNIT;
            });
            if (last) {
                this.close();
            }
        }
    }

    public void onThrowable(Throwable throwable) {
        block0: {
            SseState sseState = this.state();
            Closed$ closed$ = Closed$.MODULE$;
            if (!(sseState == null ? closed$ != null : !sseState.equals(closed$))) break block0;
            this.close();
            this.sendOnThrowable(throwable);
        }
    }

    public void sendOnThrowable(Throwable throwable) {
        BoxedUnit boxedUnit;
        String errorMessage = Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable));
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Request failed", throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Request failed: {}", new Object[]{errorMessage});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SseState sseState = this.state();
        boolean bl = Connecting$.MODULE$.equals(sseState) ? true : Connected$.MODULE$.equals(sseState);
        if (bl) {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.sseActor);
            SseStreamCrashed x$1 = new SseStreamCrashed(throwable, this.clock.nowMillis());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (Closed$.MODULE$.equals(sseState)) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("unexpected state closed with error message: {}", new Object[]{errorMessage});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit3;
        } else {
            throw new MatchError((Object)sseState);
        }
    }

    @Override
    public void close() {
        block1: {
            SseState sseState = this.state();
            Closed$ closed$ = Closed$.MODULE$;
            if (!(sseState == null ? closed$ != null : !sseState.equals(closed$))) break block1;
            this.state_$eq(Closed$.MODULE$);
            if (this.channel() != null) {
                this.channel().close();
                this.channel_$eq(null);
            }
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.sseActor);
            SseStreamClosed x$1 = new SseStreamClosed(this.clock.nowMillis());
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    @Override
    public void dispatchEventStream(ServerSentEvent sse) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.sseActor);
        SseReceived x$1 = new SseReceived(sse.asJsonString(), this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public SseListener(ActorRef sseActor, StatsEngine statsEngine, Clock clock) {
        this.sseActor = sseActor;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.state = Connecting$.MODULE$;
        this.decoder = new SseStreamDecoder();
    }
}

