/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.resolver;

import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q!\u0003\u0006\u0001\u0019IA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\tu\u0001\u0011\t\u0011)A\u00057!)1\b\u0001C\u0001y!)\u0011\t\u0001C!\u0005\")\u0011\t\u0001C!\u001b\")A\u000b\u0001C!+\")A\u000b\u0001C!;\")\u0011\r\u0001C!E\nA\u0012\t\\5bg\u0016\u001c\u0018i^1sK:\u000bW.\u001a*fg>dg/\u001a:\u000b\u0005-a\u0011\u0001\u0003:fg>dg/\u001a:\u000b\u00055q\u0011\u0001\u00025uiBT!a\u0004\t\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011#\u0001\u0002j_N\u0019\u0001aE\u000e\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001\u00027b]\u001eT\u0011\u0001G\u0001\u0005U\u00064\u0018-\u0003\u0002\u001b+\t1qJ\u00196fGR\u00042\u0001\b\u0011#\u001b\u0005i\"BA\u0006\u001f\u0015\ty\u0002#A\u0003oKR$\u00180\u0003\u0002\";\taa*Y7f%\u0016\u001cx\u000e\u001c<feB\u00111EJ\u0007\u0002I)\u0011QeF\u0001\u0004]\u0016$\u0018BA\u0014%\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\u0002\u000f\u0005d\u0017.Y:fg\u000e\u0001\u0001\u0003B\u00165o\tr!\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=J\u0013A\u0002\u001fs_>$hHC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u00121!T1q\u0015\t\u0019\u0004\u0007\u0005\u0002,q%\u0011\u0011H\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u000f]\u0014\u0018\r\u001d9fI\u00061A(\u001b8jiz\"2!P A!\tq\u0004!D\u0001\u000b\u0011\u0015A3\u00011\u0001+\u0011\u0015Q4\u00011\u0001\u001c\u0003\u001d\u0011Xm]8mm\u0016$\"aQ&\u0011\u0007\u0011K%%D\u0001F\u0015\t1u)\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\u0013\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003\u0015\u0016\u0013aAR;ukJ,\u0007\"\u0002'\u0005\u0001\u00049\u0014!A:\u0015\u0007\rsu\nC\u0003M\u000b\u0001\u0007q\u0007C\u0003Q\u000b\u0001\u0007\u0011+A\u0004qe>l\u0017n]3\u0011\u0007\u0011\u0013&%\u0003\u0002T\u000b\n9\u0001K]8nSN,\u0017A\u0003:fg>dg/Z!mYR\u0011a\u000b\u0018\t\u0004\t&;\u0006c\u0001-[E5\t\u0011L\u0003\u0002I/%\u00111,\u0017\u0002\u0005\u0019&\u001cH\u000fC\u0003M\r\u0001\u0007q\u0007F\u0002W=~CQ\u0001T\u0004A\u0002]BQ\u0001U\u0004A\u0002\u0001\u00042\u0001\u0012*X\u0003\u0015\u0019Gn\\:f)\u0005\u0019\u0007C\u00013f\u001b\u0005\u0001\u0014B\u000141\u0005\u0011)f.\u001b;")
public class AliasesAwareNameResolver
implements NameResolver<InetAddress> {
    private final Map<String, InetAddress> aliases;
    private final NameResolver<InetAddress> wrapped;

    public Future<InetAddress> resolve(String s) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = ImmediateEventExecutor.INSTANCE.newPromise().setSuccess((Object)address);
        } else {
            future = this.wrapped.resolve(s);
        }
        return future;
    }

    public Future<InetAddress> resolve(String s, Promise<InetAddress> promise) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = promise.setSuccess((Object)address);
        } else {
            future = this.wrapped.resolve(s, promise);
        }
        return future;
    }

    public Future<List<InetAddress>> resolveAll(String s) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = ImmediateEventExecutor.INSTANCE.newPromise().setSuccess(Collections.singletonList(address));
        } else {
            future = this.wrapped.resolveAll(s);
        }
        return future;
    }

    public Future<List<InetAddress>> resolveAll(String s, Promise<List<InetAddress>> promise) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = promise.setSuccess(Collections.singletonList(address));
        } else {
            future = this.wrapped.resolveAll(s, promise);
        }
        return future;
    }

    public void close() {
        this.wrapped.close();
    }

    public AliasesAwareNameResolver(Map<String, InetAddress> aliases, NameResolver<InetAddress> wrapped) {
        this.aliases = aliases;
        this.wrapped = wrapped;
    }
}

