/*
 * Copyright (c) 2025-2025, fubluesky (fubluesky@foxmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.guoshiqiufeng.dify.dataset.dto.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author yanghq
 * @version 1.0
 * @since 2025/3/13 13:12
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class DatasetPageRequest extends BaseDatasetRequest implements Serializable {

    /**
     * 页码
     */
    private Integer page = 1;

    /**
     * 返回条数，默认 20，范围 1-100
     */
    private Integer limit = 20;

    private String keyword;

    private List<String> tagIds;

    private Boolean includeAll;
}
