/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.utils;

import io.github.linpeilie.processor.utils.FileReader;
import io.github.linpeilie.processor.utils.FileWriter;
import io.github.linpeilie.processor.utils.ThreadUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileUtils {
    public static <T> File writeUtf8Lines(Collection<T> list, File file) {
        return FileUtils.writeLines(list, file, StandardCharsets.UTF_8);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset) {
        return FileUtils.writeLines(list, file, charset, false);
    }

    public static <T> File writeLines(Collection<T> list, File file, Charset charset, boolean isAppend) {
        return FileWriter.create(file, charset).writeLines(list, isAppend);
    }

    public static List<String> readUtf8Lines(File file) {
        return FileUtils.readLines(file, StandardCharsets.UTF_8);
    }

    public static List<String> readLines(File file, Charset charset) {
        return FileUtils.readLines(file, charset, new ArrayList());
    }

    public static <T extends Collection<String>> T readLines(File file, Charset charset, T collection) {
        return FileReader.create(file, charset).readLines(collection);
    }

    public static BufferedInputStream getInputStream(File file) throws IOException {
        return new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static BufferedReader getReader(File file, Charset charset) throws IOException {
        BufferedInputStream in = FileUtils.getInputStream(file);
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, charset);
        return new BufferedReader(reader);
    }

    public static File mkParentDirs(File file) {
        if (null == file) {
            return null;
        }
        return FileUtils.mkdir(FileUtils.getParent(file, 1));
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return FileUtils.getParent(parentFile, level - 1);
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            FileUtils.mkdirsSafely(dir, 5, 1L);
        }
        return dir;
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            ThreadUtils.sleep(sleepMillis);
        }
        return dir.exists();
    }

    public static File touch(File file) {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtils.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new UncheckedIOException(new IOException(e));
            }
        }
        return file;
    }

    public static boolean isNotEmpty(File file) {
        return !FileUtils.isEmpty(file);
    }

    public static boolean isEmpty(File file) {
        if (null == file || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] subFiles = file.list();
            return subFiles == null || subFiles.length == 0;
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }
}

