/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.configuration.web;

import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.auth.NacosServerAuthConfig;
import com.alibaba.nacos.core.web.NacosWebBean;
import com.alibaba.nacos.plugin.auth.impl.configuration.web.NacosAuthPluginControllerConfig;
import com.alibaba.nacos.plugin.auth.impl.configuration.web.NacosAuthPluginOldControllerConfig;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthSystemTypes;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@NacosWebBean
@EnableWebSecurity
@Import(value={NacosAuthPluginControllerConfig.class, NacosAuthPluginOldControllerConfig.class})
public class NacosAuthPluginWebConfig {
    private static final String SECURITY_IGNORE_URLS_SPILT_CHAR = ",";
    private static final String DEFAULT_ALL_PATH_PATTERN = "/**";
    private static final String PROPERTY_IGNORE_URLS = "nacos.security.ignore.urls";

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        String ignoreUrls = null;
        String authSystemType = NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE).getNacosAuthSystemType();
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(authSystemType)) {
            ignoreUrls = DEFAULT_ALL_PATH_PATTERN;
        } else if (AuthSystemTypes.LDAP.name().equalsIgnoreCase(authSystemType)) {
            ignoreUrls = DEFAULT_ALL_PATH_PATTERN;
        }
        if (StringUtils.isBlank((CharSequence)authSystemType)) {
            ignoreUrls = EnvUtil.getProperty((String)PROPERTY_IGNORE_URLS, (String)DEFAULT_ALL_PATH_PATTERN);
        }
        if (StringUtils.isBlank((CharSequence)ignoreUrls)) {
            return (SecurityFilterChain)http.build();
        }
        String finalIgnoreUrls = ignoreUrls;
        http.authorizeHttpRequests(authorizeHttpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(finalIgnoreUrls.trim().split(SECURITY_IGNORE_URLS_SPILT_CHAR))).permitAll());
        http.csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    @Bean(name={"org.springframework.security.authenticationManager"})
    @Deprecated
    public AuthenticationManager authenticationManagerBean() throws Exception {
        AuthenticationConfiguration authenticationConfiguration = (AuthenticationConfiguration)ApplicationUtils.getBean(AuthenticationConfiguration.class);
        return authenticationConfiguration.getAuthenticationManager();
    }
}

