/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthPaginationHelper;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionPersistService;
import com.alibaba.nacos.plugin.auth.impl.persistence.extrnal.AuthExternalPaginationHelperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;

public class ExternalPermissionPersistServiceImpl
implements PermissionPersistService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.persistence");
    private JdbcTemplate jt;
    private String dataSourceType = "";
    private static final String PATTERN_STR = "*";

    @PostConstruct
    protected void init() {
        DataSourceService dataSource = DynamicDataSource.getInstance().getDataSource();
        this.jt = dataSource.getJdbcTemplate();
        this.dataSourceType = dataSource.getDataSourceType();
    }

    @Override
    public Page<PermissionInfo> getPermissions(String role, int pageNo, int pageSize) {
        AuthPaginationHelper<PermissionInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM permissions WHERE ";
        String sqlFetchRows = "SELECT role,resource,action FROM permissions WHERE ";
        String where = " role= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((String)role)) {
            params = Collections.singletonList(role);
        } else {
            where = " 1=1 ";
        }
        try {
            Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, AuthRowMapperManager.PERMISSION_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addPermission(String role, String resource, String action) {
        String sql = "INSERT INTO permissions (role, resource, action) VALUES (?, ?, ?)";
        try {
            this.jt.update(sql, new Object[]{role, resource, action});
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deletePermission(String role, String resource, String action) {
        String sql = "DELETE FROM permissions WHERE role=? AND resource=? AND action=?";
        try {
            this.jt.update(sql, new Object[]{role, resource, action});
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<PermissionInfo> findPermissionsLike4Page(String role, int pageNo, int pageSize) {
        AuthPaginationHelper<PermissionInfo> helper = this.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM permissions ";
        String sqlFetchRows = "SELECT role,resource,action FROM permissions ";
        StringBuilder where = new StringBuilder(" WHERE 1=1");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)role)) {
            where.append(" AND role LIKE ?");
            params.add(this.generateLikeArgument(role));
        }
        try {
            Page pageInfo = helper.fetchPage(sqlCountRows + String.valueOf(where), sqlFetchRows + String.valueOf(where), params.toArray(), pageNo, pageSize, AuthRowMapperManager.PERMISSION_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String generateLikeArgument(String s) {
        String underscore = "_";
        if (s.contains(underscore)) {
            s = s.replaceAll(underscore, "\\\\_");
        }
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public <E> AuthPaginationHelper<E> createPaginationHelper() {
        return new AuthExternalPaginationHelperImpl(this.jt, this.dataSourceType);
    }
}

