/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.roles;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionPersistService;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RolePersistService;
import com.alibaba.nacos.plugin.auth.impl.roles.AbstractCheckedRoleService;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserService;
import java.util.Collection;
import java.util.List;

public class NacosRoleServiceDirectImpl
extends AbstractCheckedRoleService
implements NacosRoleService {
    private static final int DEFAULT_PAGE_NO = 1;
    private final AuthConfigs authConfigs;
    private final RolePersistService rolePersistService;
    private final NacosUserService userDetailsService;
    private final PermissionPersistService permissionPersistService;

    public NacosRoleServiceDirectImpl(AuthConfigs authConfigs, RolePersistService rolePersistService, NacosUserService userDetailsService, PermissionPersistService permissionPersistService) {
        super(authConfigs);
        this.authConfigs = authConfigs;
        this.rolePersistService = rolePersistService;
        this.userDetailsService = userDetailsService;
        this.permissionPersistService = permissionPersistService;
    }

    @Override
    public List<RoleInfo> getRoles(String username) {
        Page<RoleInfo> roleInfoPage;
        List roleInfoList = this.getCachedRoleInfoMap().get(username);
        if (!(this.authConfigs.isCachingEnabled() && roleInfoList != null || (roleInfoPage = this.getRoles(username, "", 1, Integer.MAX_VALUE)) == null || CollectionUtils.isEmpty((Collection)(roleInfoList = roleInfoPage.getPageItems())))) {
            this.getCachedRoleInfoMap().put(username, roleInfoList);
        }
        return roleInfoList;
    }

    @Override
    public Page<RoleInfo> getRoles(String username, String role, int pageNo, int pageSize) {
        Page<RoleInfo> roles = this.rolePersistService.getRolesByUserNameAndRoleName(username, role, pageNo, pageSize);
        if (roles == null) {
            return new Page();
        }
        return roles;
    }

    @Override
    public List<RoleInfo> getAllRoles() {
        Page<RoleInfo> roleInfoPage = this.rolePersistService.getRolesByUserNameAndRoleName("", "", 1, Integer.MAX_VALUE);
        if (roleInfoPage == null) {
            return null;
        }
        return roleInfoPage.getPageItems();
    }

    @Override
    public List<PermissionInfo> getPermissions(String role) {
        Page<PermissionInfo> permissionInfoPage;
        List permissionInfoList = this.getCachedPermissionInfoMap().get(role);
        if (!(this.authConfigs.isCachingEnabled() && permissionInfoList != null || (permissionInfoPage = this.getPermissions(role, 1, Integer.MAX_VALUE)) == null || CollectionUtils.isEmpty((Collection)(permissionInfoList = permissionInfoPage.getPageItems())))) {
            this.getCachedPermissionInfoMap().put(role, permissionInfoList);
        }
        return permissionInfoList;
    }

    @Override
    public Page<PermissionInfo> getPermissions(String role, int pageNo, int pageSize) {
        Page<PermissionInfo> pageInfo = this.permissionPersistService.getPermissions(role, pageNo, pageSize);
        if (pageInfo == null) {
            return new Page();
        }
        return pageInfo;
    }

    @Override
    public void addRole(String role, String username) {
        if (this.userDetailsService.getUser(username) == null) {
            throw new IllegalArgumentException("user '" + username + "' not found!");
        }
        if ("ROLE_ADMIN".equals(role)) {
            throw new IllegalArgumentException("role 'ROLE_ADMIN' is not permitted to create!");
        }
        if (this.isUserBoundToRole(role, username)) {
            throw new IllegalArgumentException("user '" + username + "' already bound to the role '" + role + "'!");
        }
        this.rolePersistService.addRole(role, username);
        this.getCachedRoleSet().add(role);
    }

    @Override
    public void addAdminRole(String username) {
        if (this.userDetailsService.getUser(username) == null) {
            throw new IllegalArgumentException("user '" + username + "' not found!");
        }
        if (this.hasGlobalAdminRole()) {
            throw new IllegalArgumentException("role 'ROLE_ADMIN' already exist !");
        }
        this.rolePersistService.addRole("ROLE_ADMIN", username);
        this.getCachedRoleSet().add("ROLE_ADMIN");
        this.authConfigs.setHasGlobalAdminRole(true);
    }

    @Override
    public void deleteRole(String role, String userName) {
        this.rolePersistService.deleteRole(role, userName);
    }

    @Override
    public void deleteRole(String role) {
        this.rolePersistService.deleteRole(role);
        this.getCachedRoleInfoMap().remove(role);
    }

    @Override
    public void addPermission(String role, String resource, String action) {
        if (!this.getCachedRoleSet().contains(role)) {
            throw new IllegalArgumentException("role " + role + " not found!");
        }
        this.permissionPersistService.addPermission(role, resource, action);
    }

    @Override
    public void deletePermission(String role, String resource, String action) {
        this.permissionPersistService.deletePermission(role, resource, action);
    }

    @Override
    public Page<RoleInfo> findRoles(String username, String role, int pageNo, int pageSize) {
        return this.rolePersistService.findRolesLike4Page(username, role, pageNo, pageSize);
    }

    @Override
    public List<String> findRoleNames(String role) {
        return this.rolePersistService.findRolesLikeRoleName(role);
    }

    @Override
    public Page<PermissionInfo> findPermissions(String role, int pageNo, int pageSize) {
        return this.permissionPersistService.findPermissionsLike4Page(role, pageNo, pageSize);
    }

    boolean isUserBoundToRole(String role, String username) {
        Page<RoleInfo> roleInfoPage = this.rolePersistService.getRolesByUserNameAndRoleName(username, role, 1, 1);
        if (roleInfoPage == null) {
            return false;
        }
        List roleInfos = roleInfoPage.getPageItems();
        return CollectionUtils.isNotEmpty((Collection)roleInfos) && roleInfos.stream().anyMatch(roleInfo -> role.equals(roleInfo.getRole()));
    }
}

