/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.roles;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.common.http.DefaultHttpClientFactory;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.plugin.auth.impl.configuration.AuthConfigs;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.AbstractCheckedRoleService;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleService;
import com.alibaba.nacos.plugin.auth.impl.utils.RemoteServerUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRoleServiceRemoteImpl
extends AbstractCheckedRoleService
implements NacosRoleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosRoleServiceRemoteImpl.class);
    private final NacosRestTemplate nacosRestTemplate;
    private final AuthConfigs authConfigs;

    public NacosRoleServiceRemoteImpl(AuthConfigs authConfigs) {
        super(authConfigs);
        this.authConfigs = authConfigs;
        this.nacosRestTemplate = new DefaultHttpClientFactory(LOGGER).createNacosRestTemplate();
    }

    @Override
    public void addPermission(String role, String resource, String action) {
        Map<String, String> body = Map.of("role", role, "resource", resource, "action", action);
        try {
            HttpRestResult result = this.nacosRestTemplate.postForm(this.buildRemotePermissionUrlPath("/v3/auth/permission"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), null, body, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public void deletePermission(String role, String resource, String action) {
        Query query = Query.newInstance().addParam("role", (Object)role).addParam("resource", (Object)resource).addParam("action", (Object)action);
        try {
            HttpRestResult result = this.nacosRestTemplate.delete(this.buildRemotePermissionUrlPath("/v3/auth/permission"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public List<PermissionInfo> getPermissions(String role) {
        if (this.getCachedPermissionInfoMap().containsKey(role)) {
            return this.getCachedPermissionInfoMap().get(role);
        }
        this.reload();
        return this.getCachedPermissionInfoMap().get(role);
    }

    @Override
    public Page<PermissionInfo> getPermissions(String role, int pageNo, int pageSize) {
        Query query = Query.newInstance().addParam("role", (Object)role).addParam("pageNo", (Object)pageNo).addParam("pageSize", (Object)pageSize).addParam("search", (Object)"accurate");
        return this.getPermissionInfoPageFromRemote(query);
    }

    @Override
    public Page<PermissionInfo> findPermissions(String role, int pageNo, int pageSize) {
        Query query = Query.newInstance().addParam("role", (Object)role).addParam("pageNo", (Object)pageNo).addParam("pageSize", (Object)pageSize).addParam("search", (Object)"blur");
        return this.getPermissionInfoPageFromRemote(query);
    }

    @Override
    public List<RoleInfo> getRoles(String username) {
        if (this.getCachedRoleInfoMap().containsKey(username)) {
            return this.getCachedRoleInfoMap().get(username);
        }
        this.reload();
        return this.getCachedRoleInfoMap().get(username);
    }

    @Override
    public Page<RoleInfo> getRoles(String username, String role, int pageNo, int pageSize) {
        Query query = Query.newInstance().addParam("username", (Object)username).addParam("role", (Object)role).addParam("pageNo", (Object)pageNo).addParam("pageSize", (Object)pageSize).addParam("search", (Object)"accurate");
        return this.getRoleInfoPageFromRemote(query);
    }

    @Override
    public Page<RoleInfo> findRoles(String username, String role, int pageNo, int pageSize) {
        Query query = Query.newInstance().addParam("username", (Object)username).addParam("role", (Object)role).addParam("pageNo", (Object)pageNo).addParam("pageSize", (Object)pageSize).addParam("search", (Object)"blur");
        return this.getRoleInfoPageFromRemote(query);
    }

    @Override
    public List<String> findRoleNames(String role) {
        Query query = Query.newInstance().addParam("role", (Object)role);
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(this.buildRemoteRoleUrlPath("/v3/auth/role/search"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)httpResult);
            Result result = (Result)JacksonUtils.toObj((String)((String)httpResult.getData()), (TypeReference)new TypeReference<Result<List<String>>>(){});
            return (List)result.getData();
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public List<RoleInfo> getAllRoles() {
        return this.getRoles("", "", 1, Integer.MAX_VALUE).getPageItems();
    }

    @Override
    public void addRole(String role, String username) {
        if ("ROLE_ADMIN".equals(role)) {
            throw new IllegalArgumentException("role 'ROLE_ADMIN' is not permitted to create!");
        }
        Map<String, String> body = Map.of("role", role, "username", username);
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.postForm(this.buildRemoteRoleUrlPath("/v3/auth/role"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), body, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)httpResult);
            this.getCachedRoleSet().add(role);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public void deleteRole(String role, String userName) {
        Query query = Query.newInstance().addParam("role", (Object)role).addParam("userName", (Object)userName);
        try {
            HttpRestResult result = this.nacosRestTemplate.delete(this.buildRemoteRoleUrlPath("/v3/auth/role"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public void deleteRole(String role) {
        Query query = Query.newInstance().addParam("role", (Object)role);
        try {
            HttpRestResult result = this.nacosRestTemplate.delete(this.buildRemoteRoleUrlPath("/v3/auth/role"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)result);
            this.getCachedRoleSet().remove(role);
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    @Override
    public void addAdminRole(String username) {
        if (this.hasGlobalAdminRole()) {
            return;
        }
        this.getCachedRoleSet().add("ROLE_ADMIN");
        this.authConfigs.setHasGlobalAdminRole(true);
    }

    private String buildRemotePermissionUrlPath(String apiPath) {
        return "http://" + RemoteServerUtil.getOneNacosServerAddress() + RemoteServerUtil.getRemoteServerContextPath() + apiPath;
    }

    private Page<PermissionInfo> getPermissionInfoPageFromRemote(Query query) {
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(this.buildRemotePermissionUrlPath("/v3/auth/permission/list"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)httpResult);
            Result result = (Result)JacksonUtils.toObj((String)((String)httpResult.getData()), (TypeReference)new TypeReference<Result<Page<PermissionInfo>>>(){});
            return (Page)result.getData();
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }

    private String buildRemoteRoleUrlPath(String apiPath) {
        return "http://" + RemoteServerUtil.getOneNacosServerAddress() + RemoteServerUtil.getRemoteServerContextPath() + apiPath;
    }

    private Page<RoleInfo> getRoleInfoPageFromRemote(Query query) {
        try {
            HttpRestResult httpResult = this.nacosRestTemplate.get(this.buildRemoteRoleUrlPath("/v3/auth/role/list"), RemoteServerUtil.buildServerRemoteHeader(this.authConfigs), query, String.class);
            RemoteServerUtil.singleCheckResult((HttpRestResult<String>)httpResult);
            Result result = (Result)JacksonUtils.toObj((String)((String)httpResult.getData()), (TypeReference)new TypeReference<Result<Page<RoleInfo>>>(){});
            return (Page)result.getData();
        }
        catch (NacosException e) {
            throw new NacosRuntimeException(e.getErrCode(), e.getErrMsg());
        }
        catch (Exception unpectedException) {
            throw new NacosRuntimeException(500, unpectedException.getMessage());
        }
    }
}

