/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.token.impl;

import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManager;
import com.alibaba.nacos.plugin.auth.impl.token.impl.JwtTokenManager;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.Authentication;

public class CachedJwtTokenManager
implements TokenManager {
    private volatile Map<String, TokenEntity> tokenMap = new ConcurrentHashMap<String, TokenEntity>(1024);
    private volatile Map<String, TokenEntity> userMap = new ConcurrentHashMap<String, TokenEntity>(128);
    private final JwtTokenManager jwtTokenManager;

    public CachedJwtTokenManager(JwtTokenManager jwtTokenManager) {
        this.jwtTokenManager = jwtTokenManager;
    }

    @Scheduled(initialDelay=30000L, fixedDelay=60000L)
    private void cleanExpiredToken() {
        ArrayList tokens = new ArrayList();
        this.tokenMap.forEach((k, v) -> {
            if (v.getExpiredTimeMills() < System.currentTimeMillis()) {
                tokens.add(k);
            }
        });
        tokens.forEach(e -> this.tokenMap.remove(e));
        ArrayList users = new ArrayList();
        this.userMap.forEach((k, v) -> {
            if (v.getExpiredTimeMills() < System.currentTimeMillis()) {
                users.add(k);
            }
        });
        users.forEach(e -> this.userMap.remove(e));
    }

    @Override
    public String createToken(Authentication authentication) throws AccessException {
        return this.createToken(authentication.getName());
    }

    @Override
    public String createToken(String username) throws AccessException {
        String token;
        if (this.userMap.containsKey(username)) {
            token = this.userMap.get(username).getToken();
            long expiredTime = this.userMap.get(username).getExpiredTimeMills();
            if (!this.needRefresh(expiredTime)) {
                return token;
            }
        }
        token = this.jwtTokenManager.createToken(username);
        NacosUser user = this.jwtTokenManager.parseToken(token);
        long expiredTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.getTokenValidityInSeconds());
        Authentication authentication = this.jwtTokenManager.getAuthentication(token);
        TokenEntity model = new TokenEntity(token, username, expiredTime, authentication, user);
        this.tokenMap.put(token, model);
        this.userMap.put(username, model);
        return token;
    }

    @Override
    public Authentication getAuthentication(String token) throws AccessException {
        if (!this.tokenMap.containsKey(token)) {
            return this.jwtTokenManager.getAuthentication(token);
        }
        return this.tokenMap.get(token).getAuthentication();
    }

    @Override
    public void validateToken(String token) throws AccessException {
        if (!this.tokenMap.containsKey(token)) {
            this.jwtTokenManager.validateToken(token);
            Authentication authentication = this.jwtTokenManager.getAuthentication(token);
            String username = authentication.getName();
            if (username == null || username.isEmpty()) {
                return;
            }
            long expiredTime = TimeUnit.SECONDS.toMillis(this.jwtTokenManager.getExpiredTimeInSeconds(token));
            if (expiredTime <= System.currentTimeMillis()) {
                return;
            }
            NacosUser user = this.jwtTokenManager.parseToken(token);
            this.tokenMap.putIfAbsent(token, new TokenEntity(token, username, expiredTime, authentication, user));
        }
    }

    @Override
    public NacosUser parseToken(String token) throws AccessException {
        if (!this.tokenMap.containsKey(token)) {
            Authentication authentication = this.jwtTokenManager.getAuthentication(token);
            String username = authentication.getName();
            if (username == null || username.isEmpty()) {
                throw new AccessException("invalid token, username is empty");
            }
            long expiredTime = TimeUnit.SECONDS.toMillis(this.jwtTokenManager.getExpiredTimeInSeconds(token));
            if (expiredTime <= System.currentTimeMillis()) {
                throw new AccessException("expired token");
            }
            NacosUser user = this.jwtTokenManager.parseToken(token);
            this.tokenMap.putIfAbsent(token, new TokenEntity(token, username, expiredTime, authentication, user));
            return user;
        }
        return this.tokenMap.get(token).getNacosUser();
    }

    @Override
    public long getTokenTtlInSeconds(String token) throws AccessException {
        if (this.tokenMap.containsKey(token)) {
            return TimeUnit.MILLISECONDS.toSeconds(this.tokenMap.get(token).getExpiredTimeMills() - System.currentTimeMillis());
        }
        return this.jwtTokenManager.getTokenTtlInSeconds(token);
    }

    @Override
    public long getTokenValidityInSeconds() {
        return this.jwtTokenManager.getTokenValidityInSeconds();
    }

    private boolean needRefresh(long expiredTimeMills) {
        long refreshWindowMills = TimeUnit.SECONDS.toMillis(this.getTokenValidityInSeconds() / 10L);
        return System.currentTimeMillis() + refreshWindowMills > expiredTimeMills;
    }

    static class TokenEntity {
        private String token;
        private String userName;
        private long expiredTimeMills;
        private Authentication authentication;
        private NacosUser nacosUser;

        public TokenEntity(String token, String userName, long expiredTimeMills, Authentication authentication, NacosUser nacosUser) {
            this.token = token;
            this.userName = userName;
            this.expiredTimeMills = expiredTimeMills;
            this.authentication = authentication;
            this.nacosUser = nacosUser;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public long getExpiredTimeMills() {
            return this.expiredTimeMills;
        }

        public void setExpiredTimeMills(long expiredTimeMills) {
            this.expiredTimeMills = expiredTimeMills;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        public NacosUser getNacosUser() {
            return this.nacosUser;
        }

        public void setNacosUser(NacosUser nacosUser) {
            this.nacosUser = nacosUser;
        }

        public String toString() {
            return "TokenEntity{token='" + this.token + "', userName='" + this.userName + "', expiredTimeMills=" + this.expiredTimeMills + ", authentication=" + String.valueOf(this.authentication) + ", nacosUser=" + String.valueOf(this.nacosUser) + "}";
        }
    }
}

