/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.users;

import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class AbstractCachedUserService
implements NacosUserService {
    private Map<String, User> userMap = new ConcurrentHashMap<String, User>();

    protected AbstractCachedUserService() {
    }

    protected Map<String, User> getCachedUserMap() {
        return this.userMap;
    }

    @Scheduled(initialDelay=5000L, fixedDelay=15000L)
    protected void reload() {
        try {
            Page<User> users = this.getUsers(1, Integer.MAX_VALUE, "");
            if (users == null) {
                return;
            }
            ConcurrentHashMap<String, User> map = new ConcurrentHashMap<String, User>(16);
            for (User user : users.getPageItems()) {
                map.put(user.getUsername(), user);
            }
            this.userMap = map;
        }
        catch (Exception e) {
            Loggers.AUTH.warn("[LOAD-USERS] load failed", (Throwable)e);
        }
    }
}

