/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.utils;

import java.util.Arrays;

public class Base64Decode {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] BASE64_IALPHABET = new int[256];
    private static final int IALPHABET_MAX_INDEX = BASE64_IALPHABET.length - 1;
    private static final int[] IALPHABET = BASE64_IALPHABET;

    public static byte[] decode(String input) {
        int sIx;
        if (input == null || input.equals("")) {
            return new byte[0];
        }
        char[] sArr = input.toCharArray();
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IALPHABET[sArr[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && IALPHABET[sArr[eIx]] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == '=' ? (sArr[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int three = 3;
        int eight = 8;
        int cc = 0;
        int eLen = len / three * three;
        while (d < eLen) {
            int i = Base64Decode.ctoi(sArr[sIx++]) << 18 | Base64Decode.ctoi(sArr[sIx++]) << 12 | Base64Decode.ctoi(sArr[sIx++]) << 6 | Base64Decode.ctoi(sArr[sIx++]);
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= Base64Decode.ctoi(sArr[sIx++]) << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= eight;
            }
        }
        return dArr;
    }

    private static int ctoi(char c) {
        int i;
        int n = i = c > IALPHABET_MAX_INDEX ? -1 : IALPHABET[c];
        if (i < 0) {
            String msg = "Illegal base64 character: '" + c + "'";
            throw new IllegalArgumentException(msg);
        }
        return i;
    }

    static {
        Arrays.fill(BASE64_IALPHABET, -1);
        int iS = BASE64_ALPHABET.length;
        for (int i = 0; i < iS; ++i) {
            Base64Decode.BASE64_IALPHABET[Base64Decode.BASE64_ALPHABET[i]] = i;
        }
        Base64Decode.BASE64_IALPHABET[61] = 0;
    }
}

