/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.context;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.context.IdentityContextBuilder;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public class GrpcIdentityContextBuilder
implements IdentityContextBuilder<Request> {
    private final NacosAuthConfig authConfig;

    public GrpcIdentityContextBuilder(NacosAuthConfig authConfig) {
        this.authConfig = authConfig;
    }

    @Override
    public IdentityContext build(Request request) {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfig.getNacosAuthSystemType());
        IdentityContext result = new IdentityContext();
        this.getRemoteIp(request, result);
        if (!authPluginService.isPresent()) {
            return result;
        }
        HashSet identityNames = new HashSet(((AuthPluginService)authPluginService.get()).identityNames());
        Map map = request.getHeaders();
        for (Map.Entry entry : map.entrySet()) {
            if (!identityNames.contains(entry.getKey())) continue;
            result.setParameter((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    private void getRemoteIp(Request request, IdentityContext result) {
        result.setParameter("remote_ip", (Object)request.getHeader("X-Real-IP"));
    }
}

