/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.backups.datasource;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.backups.FailoverData;
import com.alibaba.nacos.client.naming.backups.FailoverDataSource;
import com.alibaba.nacos.client.naming.backups.FailoverSwitch;
import com.alibaba.nacos.client.naming.backups.NamingFailoverData;
import com.alibaba.nacos.client.naming.cache.DiskCache;
import com.alibaba.nacos.client.naming.utils.CacheDirUtil;
import com.alibaba.nacos.client.utils.ConcurrentDiskUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DiskFailoverDataSource
implements FailoverDataSource {
    private static final String FAILOVER_DIR = "/failover";
    private static final String IS_FAILOVER_MODE = "1";
    private static final String NO_FAILOVER_MODE = "0";
    private static final String FAILOVER_MODE_PARAM = "failover-mode";
    private static final FailoverSwitch FAILOVER_SWITCH_FALSE = new FailoverSwitch(Boolean.FALSE);
    private static final FailoverSwitch FAILOVER_SWITCH_TRUE = new FailoverSwitch(Boolean.TRUE);
    private final Map<String, String> switchParams = new ConcurrentHashMap<String, String>();
    private Map<String, FailoverData> serviceMap = new ConcurrentHashMap<String, FailoverData>();
    private String failoverDir = CacheDirUtil.getCacheDir() + "/failover";
    private long lastModifiedMillis = 0L;

    public DiskFailoverDataSource() {
        this.switchParams.put(FAILOVER_MODE_PARAM, Boolean.FALSE.toString());
    }

    @Override
    public FailoverSwitch getSwitch() {
        try {
            File switchFile = Paths.get(this.failoverDir, "00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00").toFile();
            if (!switchFile.exists()) {
                LogUtils.NAMING_LOGGER.debug("failover switch is not found, {}", (Object)switchFile.getName());
                this.switchParams.put(FAILOVER_MODE_PARAM, Boolean.FALSE.toString());
                return FAILOVER_SWITCH_FALSE;
            }
            long modified = switchFile.lastModified();
            if (this.lastModifiedMillis < modified) {
                this.lastModifiedMillis = modified;
                String failover = ConcurrentDiskUtil.getFileContent(switchFile.getPath(), Charset.defaultCharset().toString());
                if (!StringUtils.isEmpty((String)failover)) {
                    String[] lines;
                    for (String line : lines = failover.split(DiskCache.getLineSeparator())) {
                        String line1 = line.trim();
                        if (IS_FAILOVER_MODE.equals(line1)) {
                            this.switchParams.put(FAILOVER_MODE_PARAM, Boolean.TRUE.toString());
                            LogUtils.NAMING_LOGGER.info("failover-mode is on");
                            new FailoverFileReader().run();
                            return FAILOVER_SWITCH_TRUE;
                        }
                        if (!NO_FAILOVER_MODE.equals(line1)) continue;
                        this.switchParams.put(FAILOVER_MODE_PARAM, Boolean.FALSE.toString());
                        LogUtils.NAMING_LOGGER.info("failover-mode is off");
                        return FAILOVER_SWITCH_FALSE;
                    }
                }
            }
            return this.switchParams.get(FAILOVER_MODE_PARAM).equals(Boolean.TRUE.toString()) ? FAILOVER_SWITCH_TRUE : FAILOVER_SWITCH_FALSE;
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to read failover switch.", e);
            this.switchParams.put(FAILOVER_MODE_PARAM, Boolean.FALSE.toString());
            return FAILOVER_SWITCH_FALSE;
        }
    }

    @Override
    public Map<String, FailoverData> getFailoverData() {
        if (Boolean.parseBoolean(this.switchParams.get(FAILOVER_MODE_PARAM))) {
            return this.serviceMap;
        }
        return new ConcurrentHashMap<String, FailoverData>(0);
    }

    class FailoverFileReader
    implements Runnable {
        FailoverFileReader() {
        }

        @Override
        public void run() {
            HashMap<String, NamingFailoverData> domMap = new HashMap<String, NamingFailoverData>(200);
            try {
                File cacheDir = new File(DiskFailoverDataSource.this.failoverDir);
                DiskCache.createFileIfAbsent(cacheDir, true);
                File[] files = cacheDir.listFiles();
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    if (!file.isFile() || file.getName().equals("00-00---000-VIPSRV_FAILOVER_SWITCH-000---00-00")) continue;
                    for (Map.Entry<String, ServiceInfo> entry : DiskCache.parseServiceInfoFromCache(file).entrySet()) {
                        domMap.put(entry.getKey(), NamingFailoverData.newNamingFailoverData(entry.getValue()));
                    }
                }
            }
            catch (Exception e) {
                LogUtils.NAMING_LOGGER.error("[NA] failed to read cache file", (Throwable)e);
            }
            if (domMap.size() > 0) {
                DiskFailoverDataSource.this.serviceMap = domMap;
            }
        }
    }
}

