/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.event;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.client.naming.selector.NamingSelectorWrapper;
import com.alibaba.nacos.client.selector.SelectorManager;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class InstancesChangeNotifier
extends Subscriber<InstancesChangeEvent> {
    private final String eventScope;
    private final SelectorManager<NamingSelectorWrapper> selectorManager = new SelectorManager();

    @JustForTest
    public InstancesChangeNotifier() {
        this.eventScope = UUID.randomUUID().toString();
    }

    public InstancesChangeNotifier(String eventScope) {
        this.eventScope = eventScope;
    }

    public void registerListener(String groupName, String serviceName, NamingSelectorWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        String subId = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        this.selectorManager.addSelectorWrapper(subId, wrapper);
    }

    public void deregisterListener(String groupName, String serviceName, NamingSelectorWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        String subId = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        this.selectorManager.removeSelectorWrapper(subId, wrapper);
    }

    public boolean isSubscribed(String groupName, String serviceName) {
        String subId = NamingUtils.getGroupedName((String)serviceName, (String)groupName);
        return this.selectorManager.isSubscribed(subId);
    }

    public List<ServiceInfo> getSubscribeServices() {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        for (String key : this.selectorManager.getSubscriptions()) {
            serviceInfos.add(ServiceInfo.fromKey((String)key));
        }
        return serviceInfos;
    }

    public void onEvent(InstancesChangeEvent event) {
        String subId = NamingUtils.getGroupedName((String)event.getServiceName(), (String)event.getGroupName());
        Set<NamingSelectorWrapper> selectorWrappers = this.selectorManager.getSelectorWrappers(subId);
        for (NamingSelectorWrapper selectorWrapper : selectorWrappers) {
            selectorWrapper.notifyListener(event);
        }
    }

    public Class<? extends Event> subscribeType() {
        return InstancesChangeEvent.class;
    }

    public boolean scopeMatches(InstancesChangeEvent event) {
        return this.eventScope.equals(event.scope());
    }
}

