/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RpcConstants {
    public static final String NACOS_CLIENT_RPC = "nacos.remote.client.rpc";
    public static final String NACOS_SERVER_RPC = "nacos.remote.server.rpc.tls";
    public static final String NACOS_PEER_RPC = "nacos.remote.peer.rpc.tls";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_ENABLE = "nacos.remote.client.rpc.tls.enable";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_PROVIDER = "nacos.remote.client.rpc.tls.provider";
    @RpcConfigLabel
    public static final String RPC_CLIENT_MUTUAL_AUTH = "nacos.remote.client.rpc.tls.mutualAuth";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_PROTOCOLS = "nacos.remote.client.rpc.tls.protocols";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_CIPHERS = "nacos.remote.client.rpc.tls.ciphers";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_CERT_CHAIN_PATH = "nacos.remote.client.rpc.tls.certChainFile";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_CERT_KEY = "nacos.remote.client.rpc.tls.certPrivateKey";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_TRUST_PWD = "nacos.remote.client.rpc.tls.certPrivateKeyPassword";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_TRUST_COLLECTION_CHAIN_PATH = "nacos.remote.client.rpc.tls.trustCollectionChainPath";
    @RpcConfigLabel
    public static final String RPC_CLIENT_TLS_TRUST_ALL = "nacos.remote.client.rpc.tls.trustAll";
    private static final Set<String> CONFIG_NAMES;

    public static Set<String> getRpcParams() {
        return Collections.unmodifiableSet(CONFIG_NAMES);
    }

    static {
        Field[] declaredFields;
        CONFIG_NAMES = new HashSet<String>();
        Class<RpcConstants> clazz = RpcConstants.class;
        for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
            declaredField.setAccessible(true);
            if (!declaredField.getType().equals(String.class) || null == declaredField.getAnnotation(RpcConfigLabel.class)) continue;
            try {
                CONFIG_NAMES.add((String)declaredField.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public class ClientSuffix {
        public static final String TLS_ENABLE = ".tls.enable";
        public static final String TLS_PROVIDER = ".tls.provider";
        public static final String MUTUAL_AUTH = ".tls.mutualAuth";
        public static final String TLS_PROTOCOLS = ".tls.protocols";
        public static final String TLS_CIPHERS = ".tls.ciphers";
        public static final String TLS_CERT_CHAIN_PATH = ".tls.certChainFile";
        public static final String TLS_CERT_KEY = ".tls.certPrivateKey";
        public static final String TLS_TRUST_PWD = ".tls.certPrivateKeyPassword";
        public static final String TLS_TRUST_COLLECTION_CHAIN_PATH = ".tls.trustCollectionChainPath";
        public static final String TLS_TRUST_ALL = ".tls.trustAll";
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface RpcConfigLabel {
    }

    public class ServerSuffix {
        public static final String TLS_ENABLE = ".enableTls";
        public static final String TLS_PROVIDER = ".sslProvider";
        public static final String MUTUAL_AUTH = ".mutualAuthEnable";
        public static final String TLS_PROTOCOLS = ".protocols";
        public static final String TLS_CIPHERS = ".ciphers";
        public static final String TLS_CERT_CHAIN_PATH = ".certChainFile";
        public static final String TLS_CERT_KEY = ".certPrivateKey";
        public static final String TLS_TRUST_PWD = ".certPrivateKeyPassword";
        public static final String TLS_TRUST_COLLECTION_CHAIN_PATH = ".trustCollectionCertFile";
        public static final String TLS_TRUST_ALL = ".trustAll";
        public static final String SSL_CONTEXT_REFRESHER = ".sslContextRefresher";
        public static final String COMPATIBILITY = ".compatibility";
    }
}

