/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller.v3.naming;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckerFactory;
import com.alibaba.nacos.api.naming.pojo.maintainer.ServiceDetailInfo;
import com.alibaba.nacos.api.naming.pojo.maintainer.SubscriberInfo;
import com.alibaba.nacos.api.selector.Selector;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.proxy.naming.ServiceProxy;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.model.form.AggregationForm;
import com.alibaba.nacos.core.model.form.PageForm;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.model.form.ServiceForm;
import com.alibaba.nacos.naming.model.form.ServiceListForm;
import com.alibaba.nacos.naming.model.form.UpdateClusterForm;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.naming.selector.SelectorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v3/console/ns/service"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class ConsoleServiceController {
    private final ServiceProxy serviceProxy;
    private final SelectorManager selectorManager;

    public ConsoleServiceController(ServiceProxy serviceProxy, SelectorManager selectorManager) {
        this.serviceProxy = serviceProxy;
        this.selectorManager = selectorManager;
    }

    @PostMapping
    @TpsControl(pointName="NamingServiceRegister", name="HttpNamingServiceRegister")
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.CONSOLE_API)
    public Result<String> createService(ServiceForm serviceForm) throws Exception {
        serviceForm.validate();
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(serviceForm.getProtectThreshold().floatValue());
        serviceMetadata.setSelector(this.parseSelector(serviceForm.getSelector()));
        serviceMetadata.setExtendData(UtilsAndCommons.parseMetadata((String)serviceForm.getMetadata()));
        serviceMetadata.setEphemeral(serviceForm.getEphemeral().booleanValue());
        this.serviceProxy.createService(serviceForm, serviceMetadata);
        return Result.success((Object)"ok");
    }

    @DeleteMapping
    @TpsControl(pointName="NamingServiceDeregister", name="HttpNamingServiceDeregister")
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.CONSOLE_API)
    public Result<String> deleteService(ServiceForm serviceForm) throws Exception {
        serviceForm.validate();
        this.serviceProxy.deleteService(serviceForm.getNamespaceId(), serviceForm.getServiceName(), serviceForm.getGroupName());
        return Result.success((Object)"ok");
    }

    @PutMapping
    @TpsControl(pointName="NamingServiceUpdate", name="HttpNamingServiceUpdate")
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.CONSOLE_API)
    public Result<String> updateService(ServiceForm serviceForm) throws Exception {
        serviceForm.validate();
        Map metadata = UtilsAndCommons.parseMetadata((String)serviceForm.getMetadata());
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setProtectThreshold(serviceForm.getProtectThreshold().floatValue());
        serviceMetadata.setExtendData(metadata);
        serviceMetadata.setSelector(this.parseSelector(serviceForm.getSelector()));
        this.serviceProxy.updateService(serviceForm, serviceMetadata);
        return Result.success((Object)"ok");
    }

    @GetMapping(value={"/selector/types"})
    @Secured(resource="console/naming", action=ActionTypes.READ, apiType=ApiType.CONSOLE_API, tags={"only_identity"})
    public Result<List<String>> getSelectorTypeList() throws NacosException {
        return Result.success(this.serviceProxy.getSelectorTypeList());
    }

    @GetMapping(value={"/subscribers"})
    @Secured(action=ActionTypes.READ, apiType=ApiType.CONSOLE_API)
    public Result<Page<SubscriberInfo>> subscribers(ServiceForm serviceForm, PageForm pageForm, AggregationForm aggregationForm) throws Exception {
        serviceForm.validate();
        pageForm.validate();
        int pageNo = pageForm.getPageNo();
        int pageSize = pageForm.getPageSize();
        String namespaceId = serviceForm.getNamespaceId();
        String serviceName = serviceForm.getServiceName();
        String groupName = serviceForm.getGroupName();
        boolean aggregation = aggregationForm.isAggregation();
        Page<SubscriberInfo> subscribers = this.serviceProxy.getSubscribers(pageNo, pageSize, namespaceId, serviceName, groupName, aggregation);
        return Result.success(subscribers);
    }

    @Secured(action=ActionTypes.READ, apiType=ApiType.CONSOLE_API)
    @GetMapping(value={"/list"})
    public Result<Object> getServiceList(ServiceListForm serviceListForm, PageForm pageForm) throws NacosException {
        serviceListForm.validate();
        pageForm.validate();
        String namespaceId = serviceListForm.getNamespaceId();
        String serviceName = serviceListForm.getServiceNameParam();
        String groupName = serviceListForm.getGroupNameParam();
        boolean hasIpCount = serviceListForm.isIgnoreEmptyService();
        boolean withInstances = serviceListForm.isWithInstances();
        return Result.success((Object)this.serviceProxy.getServiceList(withInstances, namespaceId, pageForm.getPageNo(), pageForm.getPageSize(), serviceName, groupName, hasIpCount));
    }

    @Secured(action=ActionTypes.READ, apiType=ApiType.CONSOLE_API)
    @GetMapping
    public Result<ServiceDetailInfo> getServiceDetail(ServiceForm serviceForm) throws NacosException {
        serviceForm.validate();
        ServiceDetailInfo result = this.serviceProxy.getServiceDetail(serviceForm.getNamespaceId(), serviceForm.getServiceName(), serviceForm.getGroupName());
        return Result.success((Object)result);
    }

    @PutMapping(value={"/cluster"})
    @Secured(action=ActionTypes.WRITE, apiType=ApiType.CONSOLE_API)
    public Result<String> updateCluster(UpdateClusterForm updateClusterForm) throws Exception {
        updateClusterForm.validate();
        String namespaceId = updateClusterForm.getNamespaceId();
        String clusterName = updateClusterForm.getClusterName();
        String serviceName = updateClusterForm.getServiceName();
        String groupName = updateClusterForm.getGroupName();
        ClusterMetadata clusterMetadata = new ClusterMetadata();
        clusterMetadata.setHealthyCheckPort(updateClusterForm.getCheckPort().intValue());
        clusterMetadata.setUseInstancePortForCheck(updateClusterForm.isUseInstancePort4Check().booleanValue());
        AbstractHealthChecker healthChecker = HealthCheckerFactory.deserialize((String)updateClusterForm.getHealthChecker());
        clusterMetadata.setHealthChecker(healthChecker);
        clusterMetadata.setHealthyCheckType(healthChecker.getType());
        clusterMetadata.setExtendData(UtilsAndCommons.parseMetadata((String)updateClusterForm.getMetadata()));
        this.serviceProxy.updateClusterMetadata(namespaceId, groupName, serviceName, clusterName, clusterMetadata);
        return Result.success((Object)"ok");
    }

    private Selector parseSelector(String selectorJsonString) throws Exception {
        String expression;
        if (StringUtils.isBlank((CharSequence)selectorJsonString)) {
            return new NoneSelector();
        }
        JsonNode selectorJson = JacksonUtils.toObj((String)URLDecoder.decode(selectorJsonString, "UTF-8"));
        String type = Optional.ofNullable(selectorJson.get("type")).orElseThrow(() -> new NacosApiException(400, ErrorCode.SELECTOR_ERROR, "not match any type of selector!")).asText();
        Selector selector = this.selectorManager.parseSelector(type, expression = (String)Optional.ofNullable(selectorJson.get("expression")).map(JsonNode::asText).orElse(null));
        if (Objects.isNull(selector)) {
            throw new NacosApiException(400, ErrorCode.SELECTOR_ERROR, "not match any type of selector!");
        }
        return selector;
    }
}

