/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.handler.impl.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.NacosMember;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.cluster.RemoteServerMemberManager;
import com.alibaba.nacos.console.handler.impl.remote.EnabledRemoteHandler;
import com.alibaba.nacos.core.cluster.MemberChangeListener;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerFactory;
import com.alibaba.nacos.maintainer.client.ai.AiMaintainerService;
import com.alibaba.nacos.maintainer.client.config.ConfigMaintainerFactory;
import com.alibaba.nacos.maintainer.client.config.ConfigMaintainerService;
import com.alibaba.nacos.maintainer.client.naming.NamingMaintainerFactory;
import com.alibaba.nacos.maintainer.client.naming.NamingMaintainerService;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@EnabledRemoteHandler
public class NacosMaintainerClientHolder
extends MemberChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosMaintainerClientHolder.class);
    private final RemoteServerMemberManager memberManager;
    private volatile NamingMaintainerService namingMaintainerService;
    private volatile ConfigMaintainerService configMaintainerService;
    private volatile AiMaintainerService aiMaintainerService;

    public NacosMaintainerClientHolder(RemoteServerMemberManager memberManager) throws NacosException {
        this.memberManager = memberManager;
        this.buildMaintainerService();
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    private void buildMaintainerService() throws NacosException {
        List<String> memberAddress = this.memberManager.allMembers().stream().map(NacosMember::getAddress).toList();
        String memberAddressString = StringUtils.join(memberAddress, (String)",");
        Properties properties = new Properties();
        properties.setProperty("serverAddr", memberAddressString);
        this.namingMaintainerService = NamingMaintainerFactory.createNamingMaintainerService((Properties)properties);
        this.configMaintainerService = ConfigMaintainerFactory.createConfigMaintainerService((Properties)properties);
        this.aiMaintainerService = AiMaintainerFactory.createAiMaintainerService((Properties)properties);
    }

    public NamingMaintainerService getNamingMaintainerService() {
        return this.namingMaintainerService;
    }

    public ConfigMaintainerService getConfigMaintainerService() {
        return this.configMaintainerService;
    }

    public AiMaintainerService getAiMaintainerService() {
        return this.aiMaintainerService;
    }

    public void onEvent(MembersChangeEvent event) {
        try {
            this.buildMaintainerService();
        }
        catch (NacosException e) {
            LOGGER.warn("Nacos Server members changed, but build new maintain client failed with: ", (Throwable)e);
        }
    }
}

