/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.proxy.config;

import com.alibaba.nacos.api.config.model.ConfigBasicInfo;
import com.alibaba.nacos.api.config.model.ConfigDetailInfo;
import com.alibaba.nacos.api.config.model.ConfigGrayInfo;
import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.config.model.SameConfigPolicy;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.Page;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.config.server.controller.parameters.SameNamespaceCloneConfigBean;
import com.alibaba.nacos.config.server.model.ConfigRequestInfo;
import com.alibaba.nacos.config.server.model.form.ConfigForm;
import com.alibaba.nacos.console.handler.config.ConfigHandler;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConfigProxy {
    private final ConfigHandler configHandler;

    @Autowired
    public ConfigProxy(ConfigHandler configHandler) {
        this.configHandler = configHandler;
    }

    public Page<ConfigBasicInfo> getConfigList(int pageNo, int pageSize, String dataId, String group, String namespaceId, Map<String, Object> configAdvanceInfo) throws IOException, ServletException, NacosException {
        return this.configHandler.getConfigList(pageNo, pageSize, dataId, group, namespaceId, configAdvanceInfo);
    }

    public ConfigDetailInfo getConfigDetail(String dataId, String group, String namespaceId) throws NacosException {
        return this.configHandler.getConfigDetail(dataId, group, namespaceId);
    }

    public Boolean publishConfig(ConfigForm configForm, ConfigRequestInfo configRequestInfo) throws NacosException {
        return this.configHandler.publishConfig(configForm, configRequestInfo);
    }

    public Boolean deleteConfig(String dataId, String group, String namespaceId, String tag, String clientIp, String srcUser) throws NacosException {
        return this.configHandler.deleteConfig(dataId, group, namespaceId, tag, clientIp, srcUser);
    }

    public Boolean batchDeleteConfigs(List<Long> ids, String clientIp, String srcUser) throws NacosException {
        return this.configHandler.batchDeleteConfigs(ids, clientIp, srcUser);
    }

    public Page<ConfigBasicInfo> getConfigListByContent(String search, int pageNo, int pageSize, String dataId, String group, String namespaceId, Map<String, Object> configAdvanceInfo) throws NacosException {
        return this.configHandler.getConfigListByContent(search, pageNo, pageSize, dataId, group, namespaceId, configAdvanceInfo);
    }

    public ConfigListenerInfo getListeners(String dataId, String group, String namespaceId, boolean aggregation) throws Exception {
        return this.configHandler.getListeners(dataId, group, namespaceId, aggregation);
    }

    public ConfigListenerInfo getAllSubClientConfigByIp(String ip, boolean all, String namespaceId, boolean aggregation) throws NacosException {
        return this.configHandler.getAllSubClientConfigByIp(ip, all, namespaceId, aggregation);
    }

    public ResponseEntity<byte[]> exportConfigV2(String dataId, String group, String namespaceId, String appName, List<Long> ids) throws Exception {
        return this.configHandler.exportConfig(dataId, group, namespaceId, appName, ids);
    }

    public Result<Map<String, Object>> importAndPublishConfig(String srcUser, String namespaceId, SameConfigPolicy policy, MultipartFile file, String srcIp, String requestIpApp) throws NacosException {
        return this.configHandler.importAndPublishConfig(srcUser, namespaceId, policy, file, srcIp, requestIpApp);
    }

    public Result<Map<String, Object>> cloneConfig(String srcUser, String namespaceId, List<SameNamespaceCloneConfigBean> configBeansList, SameConfigPolicy policy, String srcIp, String requestIpApp) throws NacosException {
        return this.configHandler.cloneConfig(srcUser, namespaceId, configBeansList, policy, srcIp, requestIpApp);
    }

    public boolean removeBetaConfig(String dataId, String group, String namespaceId, String remoteIp, String requestIpApp, String srcUser) throws NacosException {
        return this.configHandler.removeBetaConfig(dataId, group, namespaceId, remoteIp, requestIpApp, srcUser);
    }

    public ConfigGrayInfo queryBetaConfig(String dataId, String group, String namespaceId) throws NacosException {
        return this.configHandler.queryBetaConfig(dataId, group, namespaceId);
    }
}

