/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.tps;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TpsMetrics {
    private String pointName;
    private String type;
    private long timeStamp;
    private TimeUnit period;
    private Counter counter;

    public TpsMetrics(String pointName, String type, long timeStamp, TimeUnit period) {
        this.pointName = pointName;
        this.type = type;
        this.timeStamp = timeStamp;
        this.period = period;
    }

    public String toString() {
        return "TpsMetrics{pointName='" + this.pointName + "', type='" + this.type + "', timeStamp=" + this.timeStamp + ", period=" + String.valueOf((Object)this.period) + ", counter=" + String.valueOf(this.counter) + "}";
    }

    public String getTimeFormatOfSecond(long timeStamp) {
        String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timeStamp));
        return format;
    }

    public String getMsg() {
        return String.join((CharSequence)"|", this.pointName, this.type, this.period.name(), this.getTimeFormatOfSecond(this.timeStamp), String.valueOf(this.counter.passCount), String.valueOf(this.counter.deniedCount));
    }

    public String getPointName() {
        return this.pointName;
    }

    public void setPointName(String pointName) {
        this.pointName = pointName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public TimeUnit getPeriod() {
        return this.period;
    }

    public void setPeriod(TimeUnit period) {
        this.period = period;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public void setCounter(Counter counter) {
        this.counter = counter;
    }

    public static class Counter {
        private long passCount;
        private long deniedCount;

        public Counter(long passCount, long deniedCount) {
            this.passCount = passCount;
            this.deniedCount = deniedCount;
        }

        public long getPassCount() {
            return this.passCount;
        }

        public void setPassCount(long passCount) {
            this.passCount = passCount;
        }

        public long getDeniedCount() {
            return this.deniedCount;
        }

        public void setDeniedCount(long deniedCount) {
            this.deniedCount = deniedCount;
        }

        public String toString() {
            return "{passCount=" + this.passCount + ", deniedCount=" + this.deniedCount + "}";
        }

        public String getSimpleLog() {
            return String.join((CharSequence)"|", String.valueOf(this.passCount), String.valueOf(this.deniedCount));
        }
    }
}

